/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.report;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.Status;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.builders.ExtentReportsFactory;
import org.jsmart.zerocode.core.domain.builders.HighChartColumnHtmlBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeChartKeyValueArrayBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeChartKeyValueBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeCsvReportBuilder;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReport;
import org.jsmart.zerocode.core.domain.reports.chart.HighChartColumnHtml;
import org.jsmart.zerocode.core.domain.reports.csv.ZeroCodeCsvReport;
import org.jsmart.zerocode.core.report.HighChartColumnHtmlWriter;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeReportGeneratorImpl
implements ZeroCodeReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeReportGeneratorImpl.class);
    private static String spikeChartFileName;
    @Inject(optional=true)
    @Named(value="report.spike.chart.enabled")
    private boolean spikeChartReportEnabled;
    @Inject
    private ObjectMapper mapper;
    private List<ZeroCodeReport> treeReports;
    private List<ZeroCodeCsvReport> zeroCodeCsvFlattenedRows;
    private List<ZeroCodeCsvReport> csvRows = new ArrayList<ZeroCodeCsvReport>();

    @Override
    public void generateExtentReport() {
        ExtentReports extentReports = ExtentReportsFactory.createReportTheme("target/zerocode-interactive.html");
        this.linkToSpikeChartIfEnabled();
        this.treeReports.forEach(thisReport -> thisReport.getResults().forEach(thisScenario -> {
            ExtentTest test = extentReports.createTest(thisScenario.getScenarioName());
            test.assignCategory(new String[]{"Regression"});
            test.assignAuthor(new String[]{this.optionalAuthor(thisScenario.getScenarioName())});
            thisScenario.getSteps().forEach(thisStep -> {
                test.getModel().setStartTime(ZeroCodeReportGeneratorImpl.utilDateOf(thisStep.getRequestTimeStamp()));
                test.getModel().setEndTime(ZeroCodeReportGeneratorImpl.utilDateOf(thisStep.getResponseTimeStamp()));
                Status testStatus = thisStep.getResult().equals("PASSED") ? Status.PASS : Status.FAIL;
                test.createNode(thisStep.getName(), "TEST-STEP-CORRELATION-ID: " + thisStep.getCorrelationId()).log(testStatus, thisStep.getName() + " has " + thisStep.getResult() + ". \n Search in the log file for-  " + "TEST-STEP-CORRELATION-ID:" + "  \n" + thisStep.getCorrelationId() + "\n" + ", url:" + thisStep.getUrl() + "\n");
                extentReports.flush();
            });
        }));
    }

    public void linkToSpikeChartIfEnabled() {
        if (this.spikeChartReportEnabled || spikeChartFileName != null) {
            String reportName = ExtentReportsFactory.getReportName();
            String linkCodeToTargetSpikeChartHtml = String.format("<code>&nbsp;&nbsp;<a href='%s' style=\"color: #006; background: #ff6;\"> %s </a></code>", spikeChartFileName, "Spike Chart(Click here)");
            ExtentReportsFactory.reportName(reportName + linkCodeToTargetSpikeChartHtml);
        }
    }

    protected String optionalAuthor(String scenarioName) {
        String authorName = StringUtils.substringBetween((String)scenarioName, (String)"@@", (String)"@@");
        if (authorName == null) {
            authorName = StringUtils.substringBetween((String)scenarioName, (String)"@@", (String)",");
        }
        if (authorName == null) {
            authorName = StringUtils.substringBetween((String)scenarioName, (String)"@@", (String)" ");
        }
        if (authorName == null) {
            authorName = scenarioName.substring(scenarioName.lastIndexOf("@@") + "@@".length());
        }
        if (scenarioName.lastIndexOf("@@") == -1 || StringUtils.isEmpty((String)authorName)) {
            authorName = "Anonymous";
        }
        return authorName;
    }

    @Override
    public void generateCsvReport() {
        this.treeReports = this.readZeroCodeReportsByPath("target/zerocode-test-reports/");
        this.zeroCodeCsvFlattenedRows = this.buildCsvRows();
        this.generateCsvReport(this.zeroCodeCsvFlattenedRows);
    }

    @Override
    public void generateHighChartReport() {
        LOGGER.info("####spikeChartReportEnabled: " + this.spikeChartReportEnabled);
        if (this.spikeChartReportEnabled) {
            HighChartColumnHtml highChartColumnHtml = this.convertCsvRowsToHighChartData(this.zeroCodeCsvFlattenedRows);
            this.generateHighChartReport(highChartColumnHtml);
        }
    }

    private HighChartColumnHtml convertCsvRowsToHighChartData(List<ZeroCodeCsvReport> zeroCodeCsvReportRows) {
        HighChartColumnHtmlBuilder highChartColumnHtmlBuilder = HighChartColumnHtmlBuilder.newInstance().chartSeriesName("Test Results").chartTitleTop("Request Vs Response Delay Chart").textYaxis("Response Delay in Milli Sec").chartTitleTopInABox("Spike Chart ( Milli Seconds )");
        ZeroCodeChartKeyValueArrayBuilder dataArrayBuilder = ZeroCodeChartKeyValueArrayBuilder.newInstance();
        zeroCodeCsvReportRows.forEach(thisRow -> dataArrayBuilder.kv(ZeroCodeChartKeyValueBuilder.newInstance().key(thisRow.getScenarioName() + "->" + thisRow.getStepName()).value(thisRow.getResponseDelayMilliSec()).result(thisRow.getResult()).build()));
        highChartColumnHtmlBuilder.testResult(dataArrayBuilder.build());
        return highChartColumnHtmlBuilder.build();
    }

    public void generateHighChartReport(HighChartColumnHtml highChartColumnHtml) {
        HighChartColumnHtmlWriter highChartColumnHtmlWriter = new HighChartColumnHtmlWriter();
        spikeChartFileName = this.createTimeStampedFileName();
        highChartColumnHtmlWriter.generateHighChart(highChartColumnHtml, spikeChartFileName);
    }

    public void generateCsvReport(List<ZeroCodeCsvReport> zeroCodeCsvReportRows) {
        CsvSchema schema = CsvSchema.builder().setUseHeader(true).addColumn("scenarioName").addColumn("scenarioLoop", CsvSchema.ColumnType.NUMBER).addColumn("stepName").addColumn("stepLoop", CsvSchema.ColumnType.NUMBER).addColumn("correlationId").addColumn("requestTimeStamp").addColumn("responseTimeStamp").addColumn("responseDelayMilliSec", CsvSchema.ColumnType.NUMBER).addColumn("result").build();
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        ObjectWriter writer = csvMapper.writer((FormatSchema)schema.withLineSeparator("\n"));
        try {
            writer.writeValue(new File("target/zerocode_full_report_" + LocalDateTime.now().toString().replace(":", "-") + ".csv"), zeroCodeCsvReportRows);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while Writing full CSV report. Details: " + e);
        }
    }

    public List<ZeroCodeCsvReport> buildCsvRows() {
        ZeroCodeCsvReportBuilder csvFileBuilder = ZeroCodeCsvReportBuilder.newInstance();
        this.treeReports.forEach(thisReport -> thisReport.getResults().forEach(thisResult -> {
            csvFileBuilder.scenarioLoop(thisResult.getLoop());
            csvFileBuilder.scenarioName(thisResult.getScenarioName());
            thisResult.getSteps().forEach(thisStep -> {
                csvFileBuilder.stepLoop(thisStep.getLoop());
                csvFileBuilder.stepName(thisStep.getName());
                csvFileBuilder.correlationId(thisStep.getCorrelationId());
                csvFileBuilder.result(thisStep.getResult());
                csvFileBuilder.requestTimeStamp(thisStep.getRequestTimeStamp().toString());
                csvFileBuilder.responseTimeStamp(thisStep.getResponseTimeStamp().toString());
                csvFileBuilder.responseDelayMilliSec(thisStep.getResponseDelay());
                this.csvRows.add(csvFileBuilder.build());
            });
        }));
        return this.csvRows;
    }

    public List<ZeroCodeReport> readZeroCodeReportsByPath(String reportsFolder) {
        this.validateReportsFolderAndTheFilesExists(reportsFolder);
        List<String> allEndPointFiles = ZeroCodeReportGeneratorImpl.getAllEndPointFilesFrom(reportsFolder);
        List<ZeroCodeReport> scenarioReports = allEndPointFiles.stream().map(reportJsonFile -> {
            try {
                return (ZeroCodeReport)this.mapper.readValue(new File((String)reportJsonFile), ZeroCodeReport.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Exception while deserializing to ZeroCodeReport. Details: " + e);
            }
        }).collect(Collectors.toList());
        return scenarioReports;
    }

    public static List<String> getAllEndPointFilesFrom(String folderName) {
        File[] files = new File(folderName).listFiles((dir, name) -> name.endsWith(".json"));
        List<String> fileNames = Optional.ofNullable(Arrays.asList(files)).orElse(Collections.emptyList()).stream().map(thisFile -> thisFile.getAbsolutePath()).collect(Collectors.toList());
        return fileNames;
    }

    protected void validateReportsFolderAndTheFilesExists(String reportsFolder) {
        try {
            File[] files = new File(reportsFolder).listFiles((dir, fileName) -> fileName.endsWith(".json"));
            Optional.ofNullable(files).orElseThrow(() -> new RuntimeException("Somehow the '" + reportsFolder + "' has got no files."));
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "\n----------------------------------------------------------------------------------------\nSomehow the '" + reportsFolder + "' is not present or has no report JSON files. \n" + "Possible reasons- \n" + "   1) No tests were activated or made to run via ZeroCode runner. -or- \n" + "   2) You have simply used @RunWith(...) and ignored all tests -or- \n" + "   3) Permission issue to create/write folder/files \n" + "   4) Please fix it by adding/activating at least one test case or fix the file permission issue\n" + "----------------------------------------------------------------------------------------\n";
            throw new RuntimeException(message);
        }
    }

    private static Date utilDateOf(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private String createTimeStampedFileName() {
        return "zerocode_results_chart" + LocalDateTime.now().toString().replace(":", "-") + ".html";
    }
}

