/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecResultBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeReportBuilder;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutor;
import org.jsmart.zerocode.core.engine.mocker.RestEndPointMocker;
import org.jsmart.zerocode.core.engine.preprocessor.ScenarioExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.StepExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesor;
import org.jsmart.zerocode.core.logbuilder.LogCorrelationshipPrinter;
import org.jsmart.zerocode.core.runner.StepNotificationHandler;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.utils.ServiceType;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeMultiStepsScenarioRunnerImpl
implements ZeroCodeMultiStepsScenarioRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeMultiStepsScenarioRunnerImpl.class);
    @Inject
    ObjectMapper objectMapper;
    @Inject
    ZeroCodeJsonTestProcesor zeroCodeJsonTestProcesor;
    @Inject
    private JsonServiceExecutor serviceExecutor;
    @Inject
    @Named(value="restful.application.endpoint.host")
    private String host;
    @Inject
    @Named(value="restful.application.endpoint.port")
    private String port;
    @Inject
    @Named(value="restful.application.endpoint.context")
    private String applicationContext;
    private LogCorrelationshipPrinter logCorrelationshipPrinter;
    private static StepNotificationHandler notificationHandler = new StepNotificationHandler();
    private ZeroCodeReportBuilder reportBuilder = ZeroCodeReportBuilder.newInstance().timeStamp(LocalDateTime.now());
    private ZeroCodeExecResultBuilder reportResultBuilder;
    private Boolean stepOutcome;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runScenario(ScenarioSpec scenario, RunNotifier notifier, Description description) {
        LOGGER.info("\n-------------------------- BDD: Scenario:{} -------------------------\n", (Object)scenario.getScenarioName());
        ScenarioExecutionState scenarioExecutionState = new ScenarioExecutionState();
        int scenarioLoopTimes = scenario.getLoop() == null ? 1 : scenario.getLoop();
        for (int k = 0; k < scenarioLoopTimes; ++k) {
            LOGGER.info("\n### Executing Scenario -->> Count No: " + k);
            this.reportResultBuilder = ZeroCodeExecResultBuilder.newInstance().loop(k).scenarioName(scenario.getScenarioName());
            for (Step thisStep : scenario.getSteps()) {
                int stepLoopTimes = thisStep.getLoop() == null ? 1 : thisStep.getLoop();
                for (int i = 0; i < stepLoopTimes; ++i) {
                    LOGGER.info("\n### Executing Step -->> Count No: " + i);
                    this.logCorrelationshipPrinter = LogCorrelationshipPrinter.newInstance(LOGGER);
                    this.logCorrelationshipPrinter.stepLoop(i);
                    String requestJsonAsString = thisStep.getRequest().toString();
                    StepExecutionState stepExecutionState = new StepExecutionState();
                    String thisStepName = thisStep.getName() + (i == 0 ? "" : Integer.valueOf(i));
                    stepExecutionState.addStep(thisStepName);
                    String resolvedRequestJson = this.zeroCodeJsonTestProcesor.resolveStringJson(requestJsonAsString, scenarioExecutionState.getResolvedScenarioState());
                    stepExecutionState.addRequest(resolvedRequestJson);
                    String executionResult = "-response not decided-";
                    ZeroCodeMultiStepsScenarioRunnerImpl zeroCodeMultiStepsScenarioRunnerImpl = this;
                    String logPrefixRelationshipId = zeroCodeMultiStepsScenarioRunnerImpl.logCorrelationshipPrinter.createRelationshipId();
                    try {
                        String serviceName = thisStep.getUrl();
                        String operationName = thisStep.getOperation();
                        serviceName = this.zeroCodeJsonTestProcesor.resolveStringJson(serviceName, scenarioExecutionState.getResolvedScenarioState());
                        LocalDateTime requestTimeStamp = LocalDateTime.now();
                        switch (this.serviceType(serviceName, operationName)) {
                            case REST_CALL: {
                                serviceName = this.getFullyQualifiedRestUrl(serviceName);
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = this.serviceExecutor.executeRESTService(serviceName, operationName, resolvedRequestJson);
                                break;
                            }
                            case JAVA_CALL: {
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = this.serviceExecutor.executeJavaService(serviceName, operationName, resolvedRequestJson);
                                break;
                            }
                            case NONE: {
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = SmartUtils.prettyPrintJson(resolvedRequestJson);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Opps! Service Undecided. If it is intentional, then leave it blank for same response as request");
                            }
                        }
                        LocalDateTime responseTimeStamp = LocalDateTime.now();
                        this.logCorrelationshipPrinter.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStamp).response(executionResult);
                        stepExecutionState.addResponse(executionResult);
                        scenarioExecutionState.addStepState(stepExecutionState.getResolvedStep());
                        String resolvedAssertionJson = this.zeroCodeJsonTestProcesor.resolveStringJson(thisStep.getAssertions().toString(), scenarioExecutionState.getResolvedScenarioState());
                        this.logCorrelationshipPrinter.assertion(SmartUtils.prettyPrintJson(resolvedAssertionJson));
                        List<JsonAsserter> asserters = this.zeroCodeJsonTestProcesor.createAssertersFrom(resolvedAssertionJson);
                        List<AssertionReport> failureResults = this.zeroCodeJsonTestProcesor.assertAllAndReturnFailed(asserters, executionResult);
                        if (!failureResults.isEmpty()) {
                            this.stepOutcome = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionFailed);
                            this.logCorrelationshipPrinter.result(this.stepOutcome);
                            boolean bl = this.stepOutcome;
                            return bl;
                        }
                        this.stepOutcome = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionPassed);
                        this.logCorrelationshipPrinter.result(this.stepOutcome);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        LOGGER.info("###Exception while executing a step in the zerocode dsl.");
                        LocalDateTime responseTimeStampEx = LocalDateTime.now();
                        this.logCorrelationshipPrinter.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStampEx).response(executionResult).exceptionMessage(ex.getMessage());
                        this.stepOutcome = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, new RuntimeException("ZeroCode Step execution failed. Details:" + ex), notificationHandler::handleStepException);
                        this.logCorrelationshipPrinter.result(this.stepOutcome);
                        boolean bl = this.stepOutcome;
                        return bl;
                    }
                    finally {
                        this.logCorrelationshipPrinter.print();
                        this.reportResultBuilder.step(this.logCorrelationshipPrinter.buildReportSingleStep());
                        if (!this.stepOutcome.booleanValue()) {
                            this.reportBuilder.result(this.reportResultBuilder.build());
                            this.reportBuilder.printToFile(scenario.getScenarioName() + ".json");
                        }
                    }
                }
            }
            this.reportBuilder.result(this.reportResultBuilder.build());
        }
        this.stopWireMockServer();
        this.reportBuilder.printToFile(scenario.getScenarioName() + ".json");
        return true;
    }

    private String getFullyQualifiedRestUrl(String serviceEndPoint) {
        if (serviceEndPoint.startsWith("http://") || serviceEndPoint.startsWith("https://")) {
            return serviceEndPoint;
        }
        return String.format("%s:%s%s%s", this.host, this.port, this.applicationContext, serviceEndPoint);
    }

    public boolean runChildStep(ScenarioSpec scenarioSpec, BiConsumer testPassHandler) {
        scenarioSpec.getSteps().forEach(step -> testPassHandler.accept(scenarioSpec.getScenarioName(), step.getName()));
        return true;
    }

    public void overridePort(int port) {
        this.port = port + "";
    }

    public void overrideHost(String host) {
        this.host = host;
    }

    public void overrideApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    private ServiceType serviceType(String serviceName, String methodName) {
        ServiceType serviceType = StringUtils.isEmpty((String)serviceName) || StringUtils.isEmpty((String)methodName) ? ServiceType.NONE : (serviceName != null && serviceName.contains("/") ? ServiceType.REST_CALL : ServiceType.JAVA_CALL);
        return serviceType;
    }

    private void stopWireMockServer() {
        if (null != RestEndPointMocker.wireMockServer) {
            RestEndPointMocker.wireMockServer.stop();
            RestEndPointMocker.wireMockServer = null;
            LOGGER.info("Scenario: All mockings done via WireMock server. Dependant end points executed. Stopped WireMock.");
        }
    }
}

