/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.di.main;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Properties;
import java.util.logging.Logger;
import org.jsmart.zerocode.core.di.module.GsonModule;
import org.jsmart.zerocode.core.di.module.HttpClientModule;
import org.jsmart.zerocode.core.di.module.ObjectMapperModule;
import org.jsmart.zerocode.core.di.module.PropertiesInjectorModule;
import org.jsmart.zerocode.core.engine.executor.JavaExecutor;
import org.jsmart.zerocode.core.engine.executor.JavaExecutorImpl;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutor;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesorImpl;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.report.ZeroCodeReportGeneratorImpl;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;

public class ApplicationMainModule
extends AbstractModule {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMainModule.class.getName());
    private final String serverEnv;

    public ApplicationMainModule(String serverEnv) {
        this.serverEnv = serverEnv;
    }

    public void configure() {
        this.install(new ObjectMapperModule());
        this.install(new HttpClientModule());
        this.install(new GsonModule());
        this.install((Module)new PropertiesInjectorModule(this.serverEnv));
        this.bind(ZeroCodeMultiStepsScenarioRunner.class).to(ZeroCodeMultiStepsScenarioRunnerImpl.class);
        this.bind(JsonServiceExecutor.class).to(JsonServiceExecutorImpl.class);
        this.bind(JavaExecutor.class).to(JavaExecutorImpl.class);
        this.bind(ZeroCodeJsonTestProcesor.class).to(ZeroCodeJsonTestProcesorImpl.class);
        this.bind(ZeroCodeReportGenerator.class).to(ZeroCodeReportGeneratorImpl.class);
        this.bind(ZeroCodeExternalFileProcessor.class).to(ZeroCodeExternalFileProcessorImpl.class);
        Names.bindProperties((Binder)this.binder(), (Properties)this.getProperties(this.serverEnv));
    }

    public Properties getProperties(String host) {
        Properties properties = new Properties();
        try {
            properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(host));
            this.checkAndLoadOldProperties(properties);
        }
        catch (Exception e) {
            LOGGER.info("###Oops!Exception### while reading target env file: " + host + ". Have you mentioned env details?");
            throw new RuntimeException("could not read the target-env properties file --" + host + "-- from the classpath.");
        }
        return properties;
    }

    private void checkAndLoadOldProperties(Properties properties) {
        Object oldPropertyValue;
        if (properties.get("web.application.endpoint.host") == null && properties.get("restful.application.endpoint.host") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.host");
            properties.setProperty("web.application.endpoint.host", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
        if (properties.get("web.application.endpoint.port") == null && properties.get("restful.application.endpoint.port") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.port");
            properties.setProperty("web.application.endpoint.port", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
        if (properties.get("web.application.endpoint.context") == null && properties.get("restful.application.endpoint.context") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.context");
            properties.setProperty("web.application.endpoint.context", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
    }
}

