/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.assertion;

import net.minidev.json.JSONArray;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;

public class ArraySizeAsserter
implements JsonAsserter {
    private final String path;
    private final int expectedSize;
    private final String expectedSizeExpression;

    public ArraySizeAsserter(String path, int size) {
        this.path = path;
        this.expectedSize = size;
        this.expectedSizeExpression = null;
    }

    public ArraySizeAsserter(String path, String expression) {
        this.path = path;
        this.expectedSizeExpression = expression;
        this.expectedSize = -1;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public AssertionReport actualEqualsToExpected(Object result) {
        if (result instanceof JSONArray) {
            JSONArray actualArrayValue = (JSONArray)result;
            if (this.expectedSize == -1 && this.expectedSizeExpression != null) {
                return this.processRelationalExpression(actualArrayValue);
            }
            if (actualArrayValue.size() == this.expectedSize) {
                return AssertionReport.createFieldMatchesReport();
            }
            return AssertionReport.createFieldDoesNotMatchReport(this.path, String.format("Array of size %d", this.expectedSize), actualArrayValue.size());
        }
        return AssertionReport.createFieldDoesNotMatchReport(this.path, "[]", result);
    }

    public AssertionReport processRelationalExpression(JSONArray actualArrayValue) {
        if (this.expectedSizeExpression.startsWith("$GT.")) {
            String greaterThan = this.expectedSizeExpression.substring("$GT.".length());
            if (actualArrayValue.size() > Integer.parseInt(greaterThan)) {
                return AssertionReport.createFieldMatchesReport();
            }
        } else if (this.expectedSizeExpression.startsWith("$LT.")) {
            String lesserThan = this.expectedSizeExpression.substring("$LT.".length());
            if (actualArrayValue.size() < Integer.parseInt(lesserThan)) {
                return AssertionReport.createFieldMatchesReport();
            }
        } else if (this.expectedSizeExpression.startsWith("$EQ.")) {
            String equalTo = this.expectedSizeExpression.substring("$EQ.".length());
            if (actualArrayValue.size() == Integer.parseInt(equalTo)) {
                return AssertionReport.createFieldMatchesReport();
            }
        } else if (this.expectedSizeExpression.startsWith("$NOT.EQ.")) {
            String notEqualTo = this.expectedSizeExpression.substring("$NOT.EQ.".length());
            if (actualArrayValue.size() != Integer.parseInt(notEqualTo)) {
                return AssertionReport.createFieldMatchesReport();
            }
        }
        return AssertionReport.createFieldDoesNotMatchReport(this.path, String.format("Array of size %s", this.expectedSizeExpression), actualArrayValue.size());
    }
}

