/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.preprocessor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.engine.assertion.ArrayIsEmptyAsserter;
import org.jsmart.zerocode.core.engine.assertion.ArraySizeAsserter;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.FieldHasEqualNumberValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasExactValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasGreaterThanValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasInEqualNumberValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasLesserThanValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasSubStringIgnoreCaseValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldHasSubStringValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldIsNotNullAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldIsNullAsserter;
import org.jsmart.zerocode.core.engine.assertion.FieldMatchesRegexPatternAsserter;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesor;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeJsonTestProcesorImpl
implements ZeroCodeJsonTestProcesor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeJsonTestProcesorImpl.class);
    final List<String> propertyKeys = new ArrayList<String>();
    final Properties properties = new Properties();
    public static final String JSON_PAYLOAD_FILE = "JSON.FILE:";
    private static final String PREFIX_ASU = "ASU";
    private static final String RANDOM_NUMBER = "RANDOM.NUMBER";
    private static final String RANDOM_STRING_PREFIX = "RANDOM.STRING:";
    private static final String STATIC_ALPHABET = "STATIC.ALPHABET:";
    private static final String LOCALDATE_TODAY = "LOCAL.DATE.TODAY:";
    private static final String LOCALDATETIME_NOW = "LOCAL.DATETIME.NOW:";
    private static final String XML_FILE = "XML.FILE:";
    private static final String RANDOM_UU_ID = "RANDOM.UUID";
    private static final String RECORD_DUMP = "RECORD.DUMP:";
    private static final List<String> availableTokens = Arrays.asList("ASU", "RANDOM.NUMBER", "RANDOM.STRING:", "STATIC.ALPHABET:", "LOCAL.DATE.TODAY:", "LOCAL.DATETIME.NOW:", "XML.FILE:", "RANDOM.UUID", "RECORD.DUMP:");
    public static final String ASSERT_VALUE_NOT_NULL = "$NOT.NULL";
    public static final String ASSERT_VALUE_NULL = "$NULL";
    public static final String ASSERT_VALUE_EMPTY_ARRAY = "$[]";
    public static final String ASSERT_PATH_SIZE = ".SIZE";
    public static final String ASSERT_VALUE_CONTAINS_STRING = "$CONTAINS.STRING:";
    public static final String ASSERT_VALUE_MATCHES_STRING = "$MATCHES.STRING:";
    public static final String ASSERT_VALUE_CONTAINS_STRING_IGNORE_CASE = "$CONTAINS.STRING.IGNORECASE:";
    public static final String ASSERT_VALUE_EQUAL_TO_NUMBER = "$EQ.";
    public static final String ASSERT_VALUE_NOT_EQUAL_TO_NUMBER = "$NOT.EQ.";
    public static final String ASSERT_VALUE_GREATER_THAN = "$GT.";
    public static final String ASSERT_VALUE_LESSER_THAN = "$LT.";
    public static final String ASSERT_PATH_VALUE_NODE = "$";
    private static final String RAW_BODY = ".rawBody";
    private final ObjectMapper mapper;
    private final String hostFileName;

    @Inject
    public ZeroCodeJsonTestProcesorImpl(ObjectMapper mapper, @Named(value="HostFileName") String hostFileName) {
        this.mapper = mapper;
        this.hostFileName = hostFileName;
        this.loadAnnotatedHostProperties();
    }

    @Override
    public String resolveStringJson(String requestJsonOrAnyString, String scenarioStateJson) {
        HashMap parammap = new HashMap();
        List<String> allTokens = this.getAllTokens(requestJsonOrAnyString);
        allTokens.forEach(runTimeToken -> {
            availableTokens.forEach(inStoreToken -> {
                if (runTimeToken.startsWith((String)inStoreToken)) {
                    if (runTimeToken.startsWith(RANDOM_NUMBER)) {
                        parammap.put(runTimeToken, System.currentTimeMillis() + "");
                    } else if (runTimeToken.startsWith(RANDOM_STRING_PREFIX)) {
                        int length = Integer.parseInt(runTimeToken.substring(RANDOM_STRING_PREFIX.length()));
                        parammap.put(runTimeToken, this.createRandomAlphaString(length));
                    } else if (runTimeToken.startsWith(STATIC_ALPHABET)) {
                        int length = Integer.parseInt(runTimeToken.substring(STATIC_ALPHABET.length()));
                        parammap.put(runTimeToken, this.createStaticAlphaString(length));
                    } else if (runTimeToken.startsWith(LOCALDATE_TODAY)) {
                        String formatPattern = runTimeToken.substring(LOCALDATE_TODAY.length());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                        parammap.put(runTimeToken, LocalDate.now().format(formatter));
                    } else if (runTimeToken.startsWith(LOCALDATETIME_NOW)) {
                        String formatPattern = runTimeToken.substring(LOCALDATETIME_NOW.length());
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                        parammap.put(runTimeToken, LocalDateTime.now().format(formatter));
                    } else if (runTimeToken.startsWith(XML_FILE)) {
                        String xmlFileResource = runTimeToken.substring(XML_FILE.length());
                        String xmlString = this.getXmlContent(xmlFileResource);
                        parammap.put(runTimeToken, StringEscapeUtils.escapeJava((String)xmlString));
                    } else if (runTimeToken.startsWith(RANDOM_UU_ID)) {
                        parammap.put(runTimeToken, UUID.randomUUID().toString());
                    }
                }
            });
            if (this.isPropertyKey((String)runTimeToken)) {
                parammap.put(runTimeToken, this.properties.get(runTimeToken));
            }
        });
        StrSubstitutor sub = new StrSubstitutor(parammap);
        String resolvedFromTemplate = sub.replace(requestJsonOrAnyString);
        return this.resolveJsonPaths(resolvedFromTemplate, scenarioStateJson);
    }

    @Override
    public List<String> getAllTokens(String requestJsonAsString) {
        ArrayList<String> keyTokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(requestJsonAsString);
        while (matcher.find()) {
            keyTokens.add(matcher.group(1));
        }
        return keyTokens;
    }

    @Override
    public String resolveJsonPaths(String jsonString, String scenarioState) {
        List<String> jsonPaths = this.getAllJsonPathTokens(jsonString);
        HashMap paramMap = new HashMap();
        jsonPaths.forEach(thisPath -> {
            try {
                if (thisPath.endsWith(RAW_BODY)) {
                    String escapedString = StringEscapeUtils.escapeJava((String)((String)JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0])));
                    paramMap.put(thisPath, escapedString);
                } else if (JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0]) instanceof LinkedHashMap) {
                    String pathValue = this.mapper.writeValueAsString(JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0]));
                    String escapedPathValue = StringEscapeUtils.escapeJava((String)pathValue);
                    paramMap.put(thisPath, escapedPathValue);
                } else {
                    paramMap.put(thisPath, JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\nJSON:" + jsonString + "\nPossibly comments in the JSON found or bad JSON path found: " + thisPath + ", Details: " + e);
            }
        });
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(jsonString);
    }

    @Override
    public List<String> getAllJsonPathTokens(String requestJsonAsString) {
        ArrayList<String> jsonPaths = new ArrayList<String>();
        List<String> allTokens = this.getAllTokens(requestJsonAsString);
        allTokens.forEach(thisToken -> {
            if (thisToken.startsWith("$.")) {
                jsonPaths.add((String)thisToken);
            }
        });
        return jsonPaths;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<JsonAsserter> createAssertersFrom(String resolvedAssertionJson) {
        ArrayList<JsonAsserter> asserters = new ArrayList<JsonAsserter>();
        try {
            JsonNode jsonNode = this.mapper.readTree(resolvedAssertionJson);
            Map<String, Object> createFieldsKeyValuesMap = this.createAssertionKV(jsonNode, "$.");
            boolean i = true;
            for (Map.Entry<String, Object> entry : createFieldsKeyValuesMap.entrySet()) {
                void var10_11;
                String expected;
                String path = entry.getKey();
                Object value = entry.getValue();
                if (ASSERT_VALUE_NOT_NULL.equals(value)) {
                    FieldIsNotNullAsserter fieldIsNotNullAsserter = new FieldIsNotNullAsserter(path);
                } else if (ASSERT_VALUE_NULL.equals(value)) {
                    FieldIsNullAsserter fieldIsNullAsserter = new FieldIsNullAsserter(path);
                } else if (ASSERT_VALUE_EMPTY_ARRAY.equals(value)) {
                    ArrayIsEmptyAsserter arrayIsEmptyAsserter = new ArrayIsEmptyAsserter(path);
                } else if (path.endsWith(ASSERT_PATH_SIZE)) {
                    path = path.substring(0, path.length() - ASSERT_PATH_SIZE.length());
                    if (value instanceof Number) {
                        ArraySizeAsserter arraySizeAsserter = new ArraySizeAsserter(path, (Integer)value);
                    } else {
                        if (!(value instanceof String)) throw new RuntimeException(String.format("Oops! Unsupported value for .SIZE: %s", value));
                        ArraySizeAsserter arraySizeAsserter = new ArraySizeAsserter(path, (String)value);
                    }
                } else if (value instanceof String && ((String)value).startsWith(ASSERT_VALUE_CONTAINS_STRING)) {
                    expected = ((String)value).substring(ASSERT_VALUE_CONTAINS_STRING.length());
                    FieldHasSubStringValueAsserter fieldHasSubStringValueAsserter = new FieldHasSubStringValueAsserter(path, expected);
                } else if (value instanceof String && ((String)value).startsWith(ASSERT_VALUE_MATCHES_STRING)) {
                    expected = ((String)value).substring(ASSERT_VALUE_MATCHES_STRING.length());
                    FieldMatchesRegexPatternAsserter fieldMatchesRegexPatternAsserter = new FieldMatchesRegexPatternAsserter(path, expected);
                } else if (value instanceof String && ((String)value).startsWith(ASSERT_VALUE_CONTAINS_STRING_IGNORE_CASE)) {
                    expected = ((String)value).substring(ASSERT_VALUE_CONTAINS_STRING_IGNORE_CASE.length());
                    FieldHasSubStringIgnoreCaseValueAsserter fieldHasSubStringIgnoreCaseValueAsserter = new FieldHasSubStringIgnoreCaseValueAsserter(path, expected);
                } else if (value instanceof String && value.toString().startsWith(ASSERT_VALUE_EQUAL_TO_NUMBER)) {
                    expected = ((String)value).substring(ASSERT_VALUE_EQUAL_TO_NUMBER.length());
                    FieldHasEqualNumberValueAsserter fieldHasEqualNumberValueAsserter = new FieldHasEqualNumberValueAsserter(path, new BigDecimal(expected));
                } else if (value instanceof String && value.toString().startsWith(ASSERT_VALUE_NOT_EQUAL_TO_NUMBER)) {
                    expected = ((String)value).substring(ASSERT_VALUE_NOT_EQUAL_TO_NUMBER.length());
                    FieldHasInEqualNumberValueAsserter fieldHasInEqualNumberValueAsserter = new FieldHasInEqualNumberValueAsserter(path, new BigDecimal(expected));
                } else if (value instanceof String && value.toString().startsWith(ASSERT_VALUE_GREATER_THAN)) {
                    expected = ((String)value).substring(ASSERT_VALUE_GREATER_THAN.length());
                    FieldHasGreaterThanValueAsserter fieldHasGreaterThanValueAsserter = new FieldHasGreaterThanValueAsserter(path, new BigDecimal(expected));
                } else if (value instanceof String && value.toString().startsWith(ASSERT_VALUE_LESSER_THAN)) {
                    expected = ((String)value).substring(ASSERT_VALUE_LESSER_THAN.length());
                    FieldHasLesserThanValueAsserter fieldHasLesserThanValueAsserter = new FieldHasLesserThanValueAsserter(path, new BigDecimal(expected));
                } else {
                    FieldHasExactValueAsserter fieldHasExactValueAsserter = new FieldHasExactValueAsserter(path, value);
                }
                asserters.add((JsonAsserter)var10_11);
            }
            return asserters;
        }
        catch (IOException parEx) {
            throw new RuntimeException(parEx);
        }
    }

    private Map<String, Object> createAssertionKV(JsonNode jsonNode, String pathDslPrefix) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (jsonNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            jsonNode.fieldNames().forEachRemaining(fieldName -> {
                String qualifiedName = pathDslPrefix + fieldName;
                JsonNode thisNode = jsonNode.get(fieldName);
                if (thisNode.isValueNode()) {
                    Object value = this.convertJsonTypeToJavaType(jsonNode.get(fieldName));
                    resultMap.put(qualifiedName, value);
                } else {
                    String newPrefix = qualifiedName + ".";
                    resultMap.putAll(this.createAssertionKV(thisNode, newPrefix));
                }
            });
        } else if (jsonNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            int i = 0;
            Iterator arrayIterator = jsonNode.elements();
            while (arrayIterator.hasNext()) {
                JsonNode thisElementValue = (JsonNode)arrayIterator.next();
                String elementName = String.format("%s[%d]", pathDslPrefix.substring(0, pathDslPrefix.lastIndexOf(46)), i++);
                if (thisElementValue.isValueNode()) {
                    Object value = this.convertJsonTypeToJavaType(thisElementValue);
                    resultMap.put(elementName, value);
                    continue;
                }
                String newPrefix = elementName + ".";
                resultMap.putAll(this.createAssertionKV(thisElementValue, newPrefix));
            }
        } else if (jsonNode.isValueNode()) {
            Object value = this.convertJsonTypeToJavaType(jsonNode);
            resultMap.put(ASSERT_PATH_VALUE_NODE, value);
        } else {
            throw new RuntimeException(String.format("Oops! Unsupported JSON Type: %s", jsonNode.getClass().getName()));
        }
        return resultMap;
    }

    private Object convertJsonTypeToJavaType(JsonNode jsonNode) {
        if (jsonNode.isValueNode()) {
            if (jsonNode.isInt()) {
                return jsonNode.asInt();
            }
            if (jsonNode.isTextual()) {
                return jsonNode.asText();
            }
            if (jsonNode.isBoolean()) {
                return jsonNode.asBoolean();
            }
            if (jsonNode.isLong()) {
                return jsonNode.asLong();
            }
            if (jsonNode.isDouble()) {
                return jsonNode.asDouble();
            }
            if (jsonNode.isNull()) {
                return null;
            }
            throw new RuntimeException(String.format("Oops! Unsupported JSON primitive to Java : %s by the framework", jsonNode.getClass().getName()));
        }
        throw new RuntimeException(String.format("Unsupported JSON Type: %s", jsonNode.getClass().getName()));
    }

    @Override
    public List<AssertionReport> assertAllAndReturnFailed(List<JsonAsserter> asserters, String executionResult) {
        ArrayList<AssertionReport> failedReports = new ArrayList<AssertionReport>();
        asserters.forEach(asserter -> {
            AssertionReport assertionReport = asserter.assertWithJson(executionResult);
            if (!assertionReport.matches()) {
                failedReports.add(assertionReport);
            }
        });
        return failedReports;
    }

    private String createRandomAlphaString(int length) {
        StringBuilder builder = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + r.nextInt(26)));
        }
        String randomString = builder.toString();
        return randomString;
    }

    private String createStaticAlphaString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + i));
            i = i >= 26 ? 0 : i;
        }
        return builder.toString();
    }

    public static List<String> getAvailableTokens() {
        return availableTokens;
    }

    public String getXmlContent(String xmlFileResource) {
        try {
            return SmartUtils.readJsonAsString(xmlFileResource);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Oops! Problem occurred while reading the XML file '" + xmlFileResource + "', details:" + e);
        }
    }

    private void loadAnnotatedHostProperties() {
        try {
            this.properties.load(this.getClass().getClassLoader().getResourceAsStream(this.hostFileName));
        }
        catch (IOException e) {
            LOGGER.error("Problem encountered while accessing annotated host properties file '" + this.hostFileName + "'");
            throw new RuntimeException(e);
        }
        this.properties.keySet().stream().forEach(thisKey -> this.propertyKeys.add(thisKey.toString()));
    }

    private boolean isPropertyKey(String runTimeToken) {
        return this.propertyKeys.contains(runTimeToken);
    }
}

