/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.send;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jsmart.zerocode.core.di.provider.GsonSerDeProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.kafka.delivery.DeliveryDetails;
import org.jsmart.zerocode.core.kafka.helper.KafkaProducerHelper;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecord;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecords;
import org.jsmart.zerocode.core.kafka.send.message.ProducerRawRecords;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSender.class);
    @Inject(optional=true)
    @Named(value="kafka.producer.properties")
    private String producerPropertyFile;
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();
    private final Gson gson = new GsonSerDeProvider().get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String send(String brokers, String topicName, String requestJson) throws JsonProcessingException {
        producer = KafkaProducerHelper.createProducer(brokers, this.producerPropertyFile);
        deliveryDetails = null;
        recordType = KafkaProducerHelper.readRecordType(requestJson, "$.recordType");
        try {
            var9_7 = recordType;
            var10_9 = -1;
            switch (var9_7.hashCode()) {
                case 80904: {
                    if (!var9_7.equals("RAW")) break;
                    var10_9 = 0;
                    break;
                }
                case 2286824: {
                    if (!var9_7.equals("JSON")) break;
                    var10_9 = 1;
                }
            }
            switch (var10_9) {
                case 0: {
                    rawRecords = (ProducerRawRecords)this.gson.fromJson(requestJson, ProducerRawRecords.class);
                    fileName = rawRecords.getFile();
                    if (fileName == null) ** GOTO lbl62
                    file = this.validateAndGetFile(fileName);
                    try {
                        br = new BufferedReader(new FileReader(file));
                        var14_24 = null;
                        i = 0;
                        while ((line = br.readLine()) != null) {
                            record = (ProducerRecord)this.gson.fromJson(line, ProducerRecord.class);
                            KafkaSender.LOGGER.info("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                            deliveryDetails = this.sendRaw(topicName, producer, record, rawRecords.getAsync());
                            ++i;
                        }
                        if (br == null) break;
                        if (var14_24 == null) ** GOTO lbl42
                        try {
                            br.close();
                            ** break;
lbl37:
                            // 1 sources

                        }
                        catch (Throwable line) {
                            var14_24.addSuppressed(line);
                            ** break;
                        }
lbl41:
                        // 1 sources

                        break;
lbl42:
                        // 1 sources

                        br.close();
                        ** break;
lbl44:
                        // 1 sources

                        break;
                        catch (Throwable line) {
                            try {
                                var14_24 = line;
                                throw line;
                            }
                            catch (Throwable var18_36) {
                                if (br != null) {
                                    if (var14_24 != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (Throwable var19_37) {
                                            var14_24.addSuppressed(var19_37);
                                        }
                                    } else {
                                        br.close();
                                    }
                                }
                                throw var18_36;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException(ex);
                    }
lbl62:
                    // 1 sources

                    records = rawRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (i = 0; i < records.size(); ++i) {
                        KafkaSender.LOGGER.info("Sending record number: {}\n", (Object)i);
                        deliveryDetails = this.sendRaw(topicName, producer, records.get(i), rawRecords.getAsync());
                    }
                    break;
                }
                case 1: {
                    jsonRecords = (ProducerJsonRecords)this.objectMapper.readValue(requestJson, ProducerJsonRecords.class);
                    fileName = jsonRecords.getFile();
                    if (fileName == null) ** GOTO lbl112
                    file = this.validateAndGetFile(fileName);
                    br = new BufferedReader(new FileReader(file));
                    var14_25 = null;
                    i = 0;
                    while ((line = br.readLine()) != null) {
                        record = (ProducerJsonRecord)this.objectMapper.readValue(line, ProducerJsonRecord.class);
                        KafkaSender.LOGGER.info("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                        deliveryDetails = this.sendJson(topicName, producer, record, jsonRecords.getAsync());
                        ++i;
                    }
                    if (br == null) break;
                    if (var14_25 == null) ** GOTO lbl94
                    try {
                        br.close();
                        ** break;
lbl89:
                        // 1 sources

                    }
                    catch (Throwable var15_32) {
                        var14_25.addSuppressed(var15_32);
                        ** break;
                    }
lbl93:
                    // 1 sources

                    break;
lbl94:
                    // 1 sources

                    br.close();
                    ** break;
lbl96:
                    // 1 sources

                    break;
                    catch (Throwable var15_33) {
                        try {
                            var14_25 = var15_33;
                            throw var15_33;
                        }
                        catch (Throwable var20_39) {
                            if (br != null) {
                                if (var14_25 != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable var21_40) {
                                        var14_25.addSuppressed(var21_40);
                                    }
                                } else {
                                    br.close();
                                }
                            }
                            throw var20_39;
                        }
                    }
lbl112:
                    // 1 sources

                    records = jsonRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (i = 0; i < records.size(); ++i) {
                        deliveryDetails = this.sendJson(topicName, producer, records.get(i), jsonRecords.getAsync());
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported recordType '" + recordType + "'. Chose RAW or JSON");
                }
            }
        }
        catch (Exception e) {
            KafkaSender.LOGGER.error("Error in sending record. Exception : " + e);
            failedStatus = this.objectMapper.writeValueAsString((Object)new DeliveryDetails("Failed", e.getMessage()));
            var11_14 = SmartUtils.prettyPrintJson(failedStatus);
            return var11_14;
        }
        finally {
            producer.close();
        }
        return SmartUtils.prettyPrintJson(deliveryDetails);
    }

    private String sendRaw(String topicName, Producer<Long, String> producer, ProducerRecord recordToSend, Boolean isAsync) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord qualifiedRecord = KafkaProducerHelper.prepareRecordToSend(topicName, recordToSend);
        if (isAsync != null && isAsync.booleanValue()) {
            LOGGER.info("Asynchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.info("Synchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord).get();
        }
        LOGGER.info("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.info("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private String sendJson(String topicName, Producer<Long, String> producer, ProducerJsonRecord recordToSend, Boolean isAsync) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord record = KafkaProducerHelper.prepareJsonRecordToSend(topicName, recordToSend);
        if (isAsync != null && isAsync.booleanValue()) {
            LOGGER.info("Asynchronous - Producer sending JSON record - {}", (Object)record);
            metadata = (RecordMetadata)producer.send(record, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.info("Producer sending JSON record - {}", (Object)record);
            metadata = (RecordMetadata)producer.send(record).get();
        }
        LOGGER.info("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.info("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private File validateAndGetFile(String fileName) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            return new File(resource.getFile());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error accessing file: `" + fileName + "' - " + ex);
        }
    }

    class ProducerAsyncCallback
    implements Callback {
        ProducerAsyncCallback() {
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception ex) {
            if (ex != null) {
                LOGGER.error("Asynchronous Producer failed with exception - {} ", (Throwable)ex);
            } else {
                LOGGER.info("Asynchronous Producer call was successful");
            }
        }
    }
}

