/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.BiConsumer;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecResultBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeReportBuilder;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;
import org.jsmart.zerocode.core.engine.executor.JsonServiceExecutor;
import org.jsmart.zerocode.core.engine.mocker.RestEndPointMocker;
import org.jsmart.zerocode.core.engine.preprocessor.ScenarioExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.StepExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeJsonTestProcesor;
import org.jsmart.zerocode.core.logbuilder.LogCorrelationshipPrinter;
import org.jsmart.zerocode.core.runner.StepNotificationHandler;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.ServiceTypeUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeMultiStepsScenarioRunnerImpl
implements ZeroCodeMultiStepsScenarioRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeMultiStepsScenarioRunnerImpl.class);
    @Inject
    private ZeroCodeJsonTestProcesor zeroCodeJsonTestProcesor;
    @Inject
    private ZeroCodeExternalFileProcessor extFileProcessor;
    @Inject
    private JsonServiceExecutor serviceExecutor;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.host")
    private String host;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.port")
    private String port;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.context")
    private String applicationContext;
    @Inject(optional=true)
    @Named(value="kafka.bootstrap.servers")
    private String kafkaServers;
    private LogCorrelationshipPrinter logCorrelationshipPrinter;
    private static StepNotificationHandler notificationHandler = new StepNotificationHandler();
    private ZeroCodeReportBuilder reportBuilder;
    private ZeroCodeExecResultBuilder reportResultBuilder;
    private Boolean stepOutcomeGreen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean runScenario(ScenarioSpec scenario, RunNotifier notifier, Description description) {
        LOGGER.info("\n-------------------------- BDD: Scenario:{} -------------------------\n", (Object)scenario.getScenarioName());
        this.reportBuilder = ZeroCodeReportBuilder.newInstance().timeStamp(LocalDateTime.now());
        ScenarioExecutionState scenarioExecutionState = new ScenarioExecutionState();
        int scenarioLoopTimes = scenario.getLoop() == null ? 1 : scenario.getLoop();
        for (int k = 0; k < scenarioLoopTimes; ++k) {
            LOGGER.info("\n### Executing Scenario -->> Count No: " + k);
            this.reportResultBuilder = ZeroCodeExecResultBuilder.newInstance().loop(k).scenarioName(scenario.getScenarioName());
            for (Step thisStep : scenario.getSteps()) {
                int stepLoopTimes = thisStep.getLoop() == null ? 1 : thisStep.getLoop();
                for (int i = 0; i < stepLoopTimes; ++i) {
                    LOGGER.info("\n### Executing Step -->> Count No: " + i);
                    this.logCorrelationshipPrinter = LogCorrelationshipPrinter.newInstance(LOGGER);
                    this.logCorrelationshipPrinter.stepLoop(i);
                    thisStep = this.extFileProcessor.resolveExtJsonFile(thisStep);
                    String requestJsonAsString = thisStep.getRequest().toString();
                    StepExecutionState stepExecutionState = new StepExecutionState();
                    String thisStepName = thisStep.getName() + (i == 0 ? "" : Integer.valueOf(i));
                    stepExecutionState.addStep(thisStepName);
                    String resolvedRequestJson = this.zeroCodeJsonTestProcesor.resolveStringJson(requestJsonAsString, scenarioExecutionState.getResolvedScenarioState());
                    stepExecutionState.addRequest(resolvedRequestJson);
                    String executionResult = "-response not decided-";
                    String logPrefixRelationshipId = this.logCorrelationshipPrinter.createRelationshipId();
                    try {
                        boolean ignoreStepFailures;
                        String serviceName = thisStep.getUrl();
                        String operationName = thisStep.getOperation();
                        serviceName = this.zeroCodeJsonTestProcesor.resolveStringJson(serviceName, scenarioExecutionState.getResolvedScenarioState());
                        LocalDateTime requestTimeStamp = LocalDateTime.now();
                        switch (ServiceTypeUtils.serviceType(serviceName, operationName)) {
                            case REST_CALL: {
                                serviceName = RunnerUtils.getFullyQualifiedUrl(serviceName, this.host, this.port, this.applicationContext);
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = this.serviceExecutor.executeRESTService(serviceName, operationName, resolvedRequestJson);
                                break;
                            }
                            case JAVA_CALL: {
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = this.serviceExecutor.executeJavaService(serviceName, operationName, resolvedRequestJson);
                                break;
                            }
                            case KAFKA_CALL: {
                                if (this.kafkaServers == null) {
                                    throw new RuntimeException(">>> 'kafka.bootstrap.servers' property can not be null for kafka operations");
                                }
                                this.printBrokerProperties();
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                String topicName = serviceName.substring("kafka-topic:".length());
                                executionResult = this.serviceExecutor.executeKafkaService(this.kafkaServers, topicName, operationName, resolvedRequestJson);
                                break;
                            }
                            case NONE: {
                                this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(i).relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(serviceName).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJson));
                                executionResult = SmartUtils.prettyPrintJson(resolvedRequestJson);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Oops! Service Type Undecided. If it is intentional, then keep the value as empty to receive the request in the response");
                            }
                        }
                        LocalDateTime responseTimeStamp = LocalDateTime.now();
                        this.logCorrelationshipPrinter.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStamp).response(executionResult);
                        stepExecutionState.addResponse(executionResult);
                        scenarioExecutionState.addStepState(stepExecutionState.getResolvedStep());
                        String resolvedAssertionJson = this.zeroCodeJsonTestProcesor.resolveStringJson(thisStep.getAssertions().toString(), scenarioExecutionState.getResolvedScenarioState());
                        this.logCorrelationshipPrinter.assertion(SmartUtils.prettyPrintJson(resolvedAssertionJson));
                        List<JsonAsserter> asserters = this.zeroCodeJsonTestProcesor.createAssertersFrom(resolvedAssertionJson);
                        List<AssertionReport> failureResults = this.zeroCodeJsonTestProcesor.assertAllAndReturnFailed(asserters, executionResult);
                        boolean bl = ignoreStepFailures = scenario.getIgnoreStepFailures() == null ? false : scenario.getIgnoreStepFailures();
                        if (ignoreStepFailures && !failureResults.isEmpty()) {
                            this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionFailed);
                            this.logCorrelationshipPrinter.result(this.stepOutcomeGreen);
                            this.stepOutcomeGreen = true;
                            continue;
                        }
                        if (!failureResults.isEmpty()) {
                            this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionFailed);
                            this.logCorrelationshipPrinter.result(this.stepOutcomeGreen);
                            boolean bl2 = this.stepOutcomeGreen;
                            return bl2;
                        }
                        this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionPassed);
                        this.logCorrelationshipPrinter.result(this.stepOutcomeGreen);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        LOGGER.info("###Exception while executing a step in the zerocode dsl.");
                        LocalDateTime responseTimeStampEx = LocalDateTime.now();
                        this.logCorrelationshipPrinter.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStampEx).response(executionResult).exceptionMessage(ex.getMessage());
                        this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, new RuntimeException("ZeroCode Step execution failed. Details:" + ex), notificationHandler::handleStepException);
                        this.logCorrelationshipPrinter.result(this.stepOutcomeGreen);
                        boolean bl = this.stepOutcomeGreen;
                        return bl;
                    }
                    finally {
                        this.logCorrelationshipPrinter.print();
                        this.reportResultBuilder.step(this.logCorrelationshipPrinter.buildReportSingleStep());
                        if (!this.stepOutcomeGreen.booleanValue()) {
                            this.reportBuilder.result(this.reportResultBuilder.build());
                            this.reportBuilder.printToFile(scenario.getScenarioName() + this.logCorrelationshipPrinter.getCorrelationId() + ".json");
                        }
                    }
                }
            }
            this.reportBuilder.result(this.reportResultBuilder.build());
        }
        this.stopWireMockServer();
        this.reportBuilder.printToFile(scenario.getScenarioName() + this.logCorrelationshipPrinter.getCorrelationId() + ".json");
        return true;
    }

    public boolean runChildStep(ScenarioSpec scenarioSpec, BiConsumer testPassHandler) {
        scenarioSpec.getSteps().forEach(step -> testPassHandler.accept(scenarioSpec.getScenarioName(), step.getName()));
        return true;
    }

    public void overridePort(int port) {
        this.port = port + "";
    }

    public void overrideHost(String host) {
        this.host = host;
    }

    public void overrideApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    private String getFullyQualifiedRestUrl(String serviceEndPoint) {
        if (this.host == null || this.port == null) {
            throw new RuntimeException("'restful.application.endpoint.host' or 'port' - can not be null");
        }
        if (this.applicationContext == null) {
            throw new RuntimeException("'restful.application.endpoint.context' key must be present even if empty or blank");
        }
        if (serviceEndPoint.startsWith("http://") || serviceEndPoint.startsWith("https://")) {
            return serviceEndPoint;
        }
        return String.format("%s:%s%s%s", this.host, this.port, this.applicationContext, serviceEndPoint);
    }

    private void stopWireMockServer() {
        if (null != RestEndPointMocker.wireMockServer) {
            RestEndPointMocker.wireMockServer.stop();
            RestEndPointMocker.wireMockServer = null;
            LOGGER.info("Scenario: All mockings done via WireMock server. Dependant end points executed. Stopped WireMock.");
        }
    }

    private void printBrokerProperties() {
        System.out.println("---------------------------------------------------------");
        System.out.println(String.format("kafka.bootstrap.servers - %s", this.kafkaServers));
        System.out.println("---------------------------------------------------------");
    }
}

