/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.EnvProperty;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerUtils.class);

    public static String getEnvSpecificConfigFile(String serverEnv, Class<?> testClass) {
        LOGGER.info("### testClass : " + testClass);
        EnvProperty envProperty = testClass.getAnnotation(EnvProperty.class);
        if (envProperty == null) {
            return serverEnv;
        }
        String envPropNameWithPrefix = envProperty.value();
        List<String> allTokens = SmartUtils.getAllTokens(envPropNameWithPrefix);
        if (allTokens.size() >= 1 && null != SmartUtils.getEnvPropertyValue(allTokens.get(0))) {
            String propertyKey = allTokens.get(0);
            String propertyValue = SmartUtils.getEnvPropertyValue(propertyKey);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(propertyKey, propertyValue);
            String resolvedEnvPropNameWithPrefix = SmartUtils.resolveToken(envPropNameWithPrefix, paramMap);
            serverEnv = RunnerUtils.suffixEnvValue(serverEnv, resolvedEnvPropNameWithPrefix);
            LOGGER.info("Found env specific property: '{}={}', Hence using: '{}'", new Object[]{propertyKey, propertyValue, serverEnv});
        } else if (allTokens.size() >= 1) {
            String propertyKey = allTokens.get(0);
            LOGGER.info("Could not find env value for env property '{}', So using '{}'", (Object)propertyKey, (Object)serverEnv);
        } else {
            LOGGER.info("Could not find env specific property, So using '{}'", (Object)serverEnv);
        }
        return serverEnv;
    }

    public static String suffixEnvValue(String serverEnv, String resolvedEnvPropNameWithPrefix) {
        String DOT_PROPERTIES = ".properties";
        return serverEnv.replace(".properties", resolvedEnvPropNameWithPrefix + ".properties");
    }

    public static String getFullyQualifiedUrl(String serviceEndPoint, String host, String port, String applicationContext) {
        if (serviceEndPoint.startsWith("http://") || serviceEndPoint.startsWith("https://")) {
            return serviceEndPoint;
        }
        if (StringUtils.isEmpty((String)port)) {
            return String.format("%s%s%s", host, applicationContext, serviceEndPoint);
        }
        return String.format("%s:%s%s%s", host, port, applicationContext, serviceEndPoint);
    }
}

