/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.jupiter.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apiguardian.api.API;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.domain.LoadWith;
import org.jsmart.zerocode.core.domain.TestMapping;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.report.ZeroCodeReportGeneratorImpl;
import org.jsmart.zerocode.jupiter.load.JupiterLoadProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL)
public class ParallelLoadExtension
implements BeforeEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelLoadExtension.class);
    private final ObjectMapper mapper = new ObjectMapperProvider().get();
    private final ZeroCodeReportGenerator reportGenerator = new ZeroCodeReportGeneratorImpl(this.mapper);

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Method testMethod = extensionContext.getRequiredTestMethod();
        Class testClass = extensionContext.getRequiredTestClass();
        String loadPropertiesFile = this.validateAndGetLoadPropertiesFile(testClass, testMethod);
        JupiterLoadProcessor loadProcessor = new JupiterLoadProcessor(loadPropertiesFile);
        boolean chartAndDashBoardGenerationEnabled = false;
        TestMapping[] testMappingArray = (TestMapping[])testMethod.getAnnotationsByType(TestMapping.class);
        Arrays.stream(testMappingArray).forEach(thisMapping -> loadProcessor.addJupiterTest(thisMapping.testClass(), thisMapping.testMethod()));
        boolean hasFailed = loadProcessor.processMultiLoad();
        this.reportGenerator.generateCsvReport();
        if (chartAndDashBoardGenerationEnabled) {
            this.reportGenerator.generateExtentReport();
        }
        if (hasFailed) {
            this.failTest(testMethod, testClass);
        } else {
            LOGGER.debug("\nAll Passed \ud83d\udc3c. \nSee the granular 'csv report' for individual test statistics.");
        }
    }

    private void failTest(Method testMethod, Class<?> testClass) {
        String failureMessage = testClass.getName() + " with load/stress test(s): " + testMethod + " have Failed";
        LOGGER.error("\n" + failureMessage + ". \n\ud83d\udc47\na) See the 'target/' for granular 'csv report' for pass/fail/response-delay statistics.\ud83d\ude0e\n-Also- \nb) See the 'target/logs' for individual failures by their correlation-ID.\n\n");
        String testDescription = testClass + "#" + testMethod;
        Assertions.fail((String)testDescription, (Throwable)new RuntimeException(failureMessage));
    }

    protected String validateAndGetLoadPropertiesFile(Class<?> testClass, Method method) {
        LoadWith loadClassWith = testClass.getAnnotation(LoadWith.class);
        LoadWith loadMethodWith = method.getAnnotation(LoadWith.class);
        if (loadClassWith != null) {
            return loadClassWith.value();
        }
        if (loadMethodWith != null) {
            return loadMethodWith.value();
        }
        throw new RuntimeException(String.format("\n<< Ah! Missing the the @LoadWith(...) on this Class '%s' or Method '%s' >> ", testClass.getName(), method.getName()));
    }
}

