/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.jupiter.load;

import java.time.LocalDateTime;
import org.jsmart.zerocode.core.runner.parallel.LoadProcessor;
import org.jsmart.zerocode.jupiter.listener.ZeroCodeTestReportJupiterListener;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JupiterLoadProcessor
extends LoadProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JupiterLoadProcessor.class);

    public JupiterLoadProcessor(String loadPropertiesFile) {
        super(loadPropertiesFile);
    }

    public LoadProcessor addJupiterTest(Class<?> testClass, String testMethod) {
        Runnable zeroCodeJunitTest = this.createJupiterRunnable(testClass, testMethod);
        this.getExecutorServiceRunner().addRunnable(zeroCodeJunitTest);
        return this;
    }

    public void updatePassFailCount(SummaryGeneratingListener summaryListener) {
        TestExecutionSummary summary = summaryListener.getSummary();
        if (summary.getTotalFailureCount() > 0L) {
            this.getFailedCounter().incrementAndGet();
            summary.getFailures().forEach(thisFailure -> {
                TestIdentifier testIdentifier = thisFailure.getTestIdentifier();
                String exceptionMessage = thisFailure.getException().getMessage();
                LOGGER.info("\n----------------------------------------------------------------------\n");
                LOGGER.info("\n###JUnit5: Test Failed Due To --> {}, \ntestIdentifier={}", (Object)exceptionMessage, (Object)testIdentifier);
                LOGGER.info("\n----------------------------------------------------------------------\n");
            });
        } else {
            this.getPassedCounter().incrementAndGet();
        }
    }

    private void registerReportListener(Class<?> testClass, String testMethod, Launcher launcher) {
        ZeroCodeTestReportJupiterListener reportListener = new ZeroCodeTestReportJupiterListener(testClass, testMethod);
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{reportListener});
    }

    private Runnable createJupiterRunnable(Class<?> testClass, String testMethod) {
        return () -> {
            LOGGER.debug(Thread.currentThread().getName() + "\n - Parallel Junit5 test- *Start-Time = " + LocalDateTime.now());
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((Class)testClass, (String)testMethod)}).build();
            Launcher launcher = LauncherFactory.create();
            this.registerReportListener(testClass, testMethod, launcher);
            SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
            launcher.execute(request, new TestExecutionListener[0]);
            LOGGER.debug(Thread.currentThread().getName() + "\n   - Parallel Junit5 test- *End-Time = " + LocalDateTime.now());
            this.updatePassFailCount(summaryListener);
        };
    }
}

