/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.di.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class GsonSerDeProvider
implements Provider<Gson> {
    public Gson get() {
        return new GsonBuilder().registerTypeAdapterFactory(KafkaHeadersAdapter.FACTORY).create();
    }

    static class KafkaHeadersAdapter
    extends TypeAdapter<Headers> {
        static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (type.getRawType() == Headers.class) {
                    return new KafkaHeadersAdapter(gson);
                }
                return null;
            }
        };
        private final Gson gson;

        public KafkaHeadersAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter writer, Headers value) throws IOException {
            if (value == null || !value.iterator().hasNext()) {
                writer.nullValue();
            } else {
                HashMap headers = new HashMap();
                value.forEach(header -> headers.put(header.key(), new String(header.value())));
                this.gson.getAdapter(Map.class).write(writer, headers);
            }
        }

        public Headers read(JsonReader reader) throws IOException {
            RecordHeaders headers = null;
            JsonToken peek = reader.peek();
            if (JsonToken.NULL.equals((Object)peek)) {
                reader.nextNull();
            } else {
                Map map = (Map)this.gson.getAdapter(Map.class).read(reader);
                headers = new RecordHeaders();
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    headers.add(key, value == null ? null : value.getBytes());
                }
            }
            return headers;
        }
    }
}

