/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.preprocessor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minidev.json.JSONArray;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;
import org.jsmart.zerocode.core.engine.assertion.array.ArrayIsEmptyAsserterImpl;
import org.jsmart.zerocode.core.engine.assertion.array.ArraySizeAsserterImpl;
import org.jsmart.zerocode.core.engine.assertion.field.FieldContainsStringAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldContainsStringIgnoreCaseAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasDateAfterValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasDateBeforeValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasEqualNumberValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasExactValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasGreaterThanValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasInEqualNumberValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldHasLesserThanValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldIsNotNullAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldIsNullAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldIsOneOfValueAsserter;
import org.jsmart.zerocode.core.engine.assertion.field.FieldMatchesRegexPatternAsserter;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessor;
import org.jsmart.zerocode.core.utils.FieldTypeConversionUtils;
import org.jsmart.zerocode.core.utils.PropertiesProviderUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.jsmart.zerocode.core.utils.TokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeAssertionsProcessorImpl
implements ZeroCodeAssertionsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeAssertionsProcessorImpl.class);
    final List<String> propertyKeys = new ArrayList<String>();
    final Properties properties = new Properties();
    private final ObjectMapper mapper;
    private final String hostFileName;

    @Inject
    public ZeroCodeAssertionsProcessorImpl(ObjectMapper mapper, @Named(value="HostFileName") String hostFileName) {
        this.mapper = mapper;
        this.hostFileName = hostFileName;
        this.loadAnnotatedHostProperties();
    }

    @Override
    public String resolveStringJson(String requestJsonOrAnyString, String scenarioStateJson) {
        String resolvedFromTemplate = this.resolveKnownTokensAndProperties(requestJsonOrAnyString);
        String resolvedJson = this.resolveJsonPaths(resolvedFromTemplate, scenarioStateJson);
        return this.resolveFieldTypes(resolvedJson);
    }

    @Override
    public String resolveKnownTokensAndProperties(String requestJsonOrAnyString) {
        HashMap paramMap = new HashMap();
        List<String> testCaseTokens = TokenUtils.getTestCaseTokens(requestJsonOrAnyString);
        testCaseTokens.forEach(runTimeToken -> {
            TokenUtils.populateParamMap(paramMap, runTimeToken);
            if (this.isPropertyKey((String)runTimeToken)) {
                paramMap.put(runTimeToken, this.properties.get(runTimeToken));
            }
        });
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(requestJsonOrAnyString);
    }

    @Override
    public String resolveJsonPaths(String jsonString, String scenarioState) {
        List<String> jsonPaths = this.getAllJsonPathTokens(jsonString);
        HashMap paramMap = new HashMap();
        String LEAF_VAL_REGEX = "\\$[.](.*)\\$VALUE\\[\\d\\]";
        jsonPaths.forEach(thisPath -> {
            try {
                if (thisPath.endsWith(".rawBody")) {
                    String escapedString = StringEscapeUtils.escapeJava((String)((String)JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0])));
                    paramMap.put(thisPath, escapedString);
                } else if (thisPath.matches("\\$[.](.*)\\$VALUE\\[\\d\\]") || thisPath.endsWith(".$VALUE")) {
                    this.resolveLeafOnlyNodeValue(scenarioState, paramMap, (String)thisPath);
                } else {
                    Object jsonPathValue = JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0]);
                    if (this.isPathValueJson(jsonPathValue)) {
                        String jsonAsString = this.mapper.writeValueAsString(jsonPathValue);
                        String escapedJsonString = StringEscapeUtils.escapeJava((String)jsonAsString);
                        paramMap.put(thisPath, escapedJsonString);
                    } else {
                        paramMap.put(thisPath, JsonPath.read((String)scenarioState, (String)thisPath, (Predicate[])new Predicate[0]));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\nJSON:" + jsonString + "\nPossibly comments in the JSON found or bad JSON path found: " + thisPath + ",\nDetails: " + e);
            }
        });
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(jsonString);
    }

    @Override
    public List<String> getAllJsonPathTokens(String requestJsonAsString) {
        ArrayList<String> jsonPaths = new ArrayList<String>();
        List<String> allTokens = TokenUtils.getTestCaseTokens(requestJsonAsString);
        allTokens.forEach(thisToken -> {
            if (thisToken.startsWith("$.")) {
                jsonPaths.add((String)thisToken);
            }
        });
        return jsonPaths;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<JsonAsserter> createJsonAsserters(String resolvedAssertionJson) {
        ArrayList<JsonAsserter> asserters = new ArrayList<JsonAsserter>();
        try {
            JsonNode jsonNode = this.mapper.readTree(resolvedAssertionJson);
            Map<String, Object> createFieldsKeyValuesMap = this.createAssertionKV(jsonNode, "$.");
            boolean i = true;
            for (Map.Entry<String, Object> entry : createFieldsKeyValuesMap.entrySet()) {
                void var10_11;
                String expected;
                String path = entry.getKey();
                Object value = entry.getValue();
                if ("$NOT.NULL".equals(value) || "$IS.NOTNULL".equals(value)) {
                    FieldIsNotNullAsserter fieldIsNotNullAsserter = new FieldIsNotNullAsserter(path);
                } else if ("$NULL".equals(value) || "$IS.NULL".equals(value)) {
                    FieldIsNullAsserter fieldIsNullAsserter = new FieldIsNullAsserter(path);
                } else if ("$[]".equals(value)) {
                    ArrayIsEmptyAsserterImpl arrayIsEmptyAsserterImpl = new ArrayIsEmptyAsserterImpl(path);
                } else if (path.endsWith(".SIZE")) {
                    path = path.substring(0, path.length() - ".SIZE".length());
                    if (value instanceof Number) {
                        ArraySizeAsserterImpl arraySizeAsserterImpl = new ArraySizeAsserterImpl(path, (Integer)value);
                    } else {
                        if (!(value instanceof String)) throw new RuntimeException(String.format("Oops! Unsupported value for .SIZE: %s", value));
                        ArraySizeAsserterImpl arraySizeAsserterImpl = new ArraySizeAsserterImpl(path, (String)value);
                    }
                } else if (value instanceof String && ((String)value).startsWith("$CONTAINS.STRING:")) {
                    expected = ((String)value).substring("$CONTAINS.STRING:".length());
                    FieldContainsStringAsserter fieldContainsStringAsserter = new FieldContainsStringAsserter(path, expected);
                } else if (value instanceof String && ((String)value).startsWith("$MATCHES.STRING:")) {
                    expected = ((String)value).substring("$MATCHES.STRING:".length());
                    FieldMatchesRegexPatternAsserter fieldMatchesRegexPatternAsserter = new FieldMatchesRegexPatternAsserter(path, expected);
                } else if (value instanceof String && ((String)value).startsWith("$CONTAINS.STRING.IGNORECASE:")) {
                    expected = ((String)value).substring("$CONTAINS.STRING.IGNORECASE:".length());
                    FieldContainsStringIgnoreCaseAsserter fieldContainsStringIgnoreCaseAsserter = new FieldContainsStringIgnoreCaseAsserter(path, expected);
                } else if (value instanceof String && value.toString().startsWith("$EQ.")) {
                    expected = ((String)value).substring("$EQ.".length());
                    FieldHasEqualNumberValueAsserter fieldHasEqualNumberValueAsserter = new FieldHasEqualNumberValueAsserter(path, this.numberValueOf(expected));
                } else if (value instanceof String && value.toString().startsWith("$NOT.EQ.")) {
                    expected = ((String)value).substring("$NOT.EQ.".length());
                    FieldHasInEqualNumberValueAsserter fieldHasInEqualNumberValueAsserter = new FieldHasInEqualNumberValueAsserter(path, this.numberValueOf(expected));
                } else if (value instanceof String && value.toString().startsWith("$GT.")) {
                    expected = ((String)value).substring("$GT.".length());
                    FieldHasGreaterThanValueAsserter fieldHasGreaterThanValueAsserter = new FieldHasGreaterThanValueAsserter(path, this.numberValueOf(expected));
                } else if (value instanceof String && value.toString().startsWith("$LT.")) {
                    expected = ((String)value).substring("$LT.".length());
                    FieldHasLesserThanValueAsserter fieldHasLesserThanValueAsserter = new FieldHasLesserThanValueAsserter(path, this.numberValueOf(expected));
                } else if (value instanceof String && value.toString().startsWith("$LOCAL.DATETIME.AFTER:")) {
                    expected = ((String)value).substring("$LOCAL.DATETIME.AFTER:".length());
                    FieldHasDateAfterValueAsserter fieldHasDateAfterValueAsserter = new FieldHasDateAfterValueAsserter(path, this.parseLocalDateTime(expected));
                } else if (value instanceof String && value.toString().startsWith("$LOCAL.DATETIME.BEFORE:")) {
                    expected = ((String)value).substring("$LOCAL.DATETIME.BEFORE:".length());
                    FieldHasDateBeforeValueAsserter fieldHasDateBeforeValueAsserter = new FieldHasDateBeforeValueAsserter(path, this.parseLocalDateTime(expected));
                } else if (value instanceof String && value.toString().startsWith("$ONE.OF:") || value instanceof String && value.toString().startsWith("$IS.ONE.OF:")) {
                    expected = ((String)value).substring("$ONE.OF:".length());
                    FieldIsOneOfValueAsserter fieldIsOneOfValueAsserter = new FieldIsOneOfValueAsserter(path, expected);
                } else {
                    FieldHasExactValueAsserter fieldHasExactValueAsserter = new FieldHasExactValueAsserter(path, value);
                }
                asserters.add((JsonAsserter)var10_11);
            }
            return asserters;
        }
        catch (IOException parEx) {
            throw new RuntimeException(parEx);
        }
    }

    private BigDecimal numberValueOf(String expected) {
        try {
            return new BigDecimal(expected);
        }
        catch (Exception e) {
            String msg = "\nValue '" + expected + "' can not be converted to number:" + e;
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
    }

    private Map<String, Object> createAssertionKV(JsonNode jsonNode, String pathDslPrefix) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (jsonNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            jsonNode.fieldNames().forEachRemaining(fieldName -> {
                String qualifiedName = pathDslPrefix + fieldName;
                JsonNode thisNode = jsonNode.get(fieldName);
                if (thisNode.isValueNode()) {
                    Object value = this.convertJsonTypeToJavaType(jsonNode.get(fieldName));
                    resultMap.put(qualifiedName, value);
                } else {
                    String newPrefix = qualifiedName + ".";
                    resultMap.putAll(this.createAssertionKV(thisNode, newPrefix));
                }
            });
        } else if (jsonNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            int i = 0;
            Iterator arrayIterator = jsonNode.elements();
            while (arrayIterator.hasNext()) {
                JsonNode thisElementValue = (JsonNode)arrayIterator.next();
                String elementName = String.format("%s[%d]", pathDslPrefix.substring(0, pathDslPrefix.lastIndexOf(46)), i++);
                if (thisElementValue.isValueNode()) {
                    Object value = this.convertJsonTypeToJavaType(thisElementValue);
                    resultMap.put(elementName, value);
                    continue;
                }
                String newPrefix = elementName + ".";
                resultMap.putAll(this.createAssertionKV(thisElementValue, newPrefix));
            }
        } else if (jsonNode.isValueNode()) {
            Object value = this.convertJsonTypeToJavaType(jsonNode);
            resultMap.put("$", value);
        } else {
            throw new RuntimeException(String.format("Oops! Unsupported JSON Type: %s", jsonNode.getClass().getName()));
        }
        return resultMap;
    }

    private Object convertJsonTypeToJavaType(JsonNode jsonNode) {
        if (jsonNode.isValueNode()) {
            if (jsonNode.isInt()) {
                return jsonNode.asInt();
            }
            if (jsonNode.isTextual()) {
                return jsonNode.asText();
            }
            if (jsonNode.isBoolean()) {
                return jsonNode.asBoolean();
            }
            if (jsonNode.isLong()) {
                return jsonNode.asLong();
            }
            if (jsonNode.isDouble()) {
                return jsonNode.asDouble();
            }
            if (jsonNode.isNull()) {
                return null;
            }
            throw new RuntimeException(String.format("Oops! Unsupported JSON primitive to Java : %s by the framework", jsonNode.getClass().getName()));
        }
        throw new RuntimeException(String.format("Unsupported JSON Type: %s", jsonNode.getClass().getName()));
    }

    @Override
    public List<FieldAssertionMatcher> assertAllAndReturnFailed(List<JsonAsserter> asserters, String executionResult) {
        ArrayList<FieldAssertionMatcher> failedReports = new ArrayList<FieldAssertionMatcher>();
        asserters.forEach(asserter -> {
            FieldAssertionMatcher fieldMatcher = asserter.assertWithJson(executionResult);
            if (!fieldMatcher.matches()) {
                failedReports.add(fieldMatcher);
            }
        });
        return failedReports;
    }

    private void loadAnnotatedHostProperties() {
        try {
            if (SmartUtils.isValidAbsolutePath(this.hostFileName)) {
                PropertiesProviderUtils.loadAbsoluteProperties(this.hostFileName, this.properties);
            } else {
                this.properties.load(this.getClass().getClassLoader().getResourceAsStream(this.hostFileName));
            }
        }
        catch (Exception e) {
            String msg = "Problem encountered while accessing annotated host properties file '";
            LOGGER.error(msg + this.hostFileName + "'");
            System.err.println(msg + this.hostFileName + "'");
            throw new RuntimeException(msg + e);
        }
        this.properties.keySet().stream().forEach(thisKey -> this.propertyKeys.add(thisKey.toString()));
    }

    private boolean isPropertyKey(String runTimeToken) {
        return this.propertyKeys.contains(runTimeToken);
    }

    private LocalDateTime parseLocalDateTime(String value) {
        return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
    }

    boolean isPathValueJson(Object jsonPathValue) {
        return jsonPathValue instanceof LinkedHashMap || jsonPathValue instanceof JSONArray;
    }

    void resolveLeafOnlyNodeValue(String scenarioState, Map<String, String> paramMap, String thisPath) {
        String actualPath = thisPath.substring(0, thisPath.indexOf(".$VALUE"));
        int index = this.findArrayIndex(thisPath, actualPath);
        List leafValuesAsArray = (List)JsonPath.read((String)scenarioState, (String)actualPath, (Predicate[])new Predicate[0]);
        paramMap.put(thisPath, (String)leafValuesAsArray.get(index));
    }

    private int findArrayIndex(String thisPath, String actualPath) {
        String valueExpr = thisPath.substring(actualPath.length());
        if (".$VALUE".equals(valueExpr)) {
            return 0;
        }
        return Integer.valueOf(StringUtils.substringBetween((String)valueExpr, (String)"[", (String)"]"));
    }

    private String resolveFieldTypes(String resolvedJson) {
        try {
            if (this.hasNoTypeCast(resolvedJson)) {
                return resolvedJson;
            }
            Map fieldMap = (Map)this.mapper.readValue(resolvedJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            FieldTypeConversionUtils.digTypeCast(fieldMap);
            return this.mapper.writeValueAsString((Object)fieldMap);
        }
        catch (Exception ex) {
            LOGGER.error("Field Type conversion exception. \nDetails:" + ex);
            throw new RuntimeException(ex);
        }
    }

    private boolean hasNoTypeCast(String resolvedJson) {
        long foundCount = FieldTypeConversionUtils.fieldTypes.stream().filter(thisType -> resolvedJson.contains((CharSequence)thisType)).count();
        return foundCount <= 0L;
    }
}

