/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.consume;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConsumerLocalConfigs {
    private final String recordType;
    private final String fileDumpTo;
    private final Boolean commitAsync;
    private final Boolean commitSync;
    private final Boolean showRecordsConsumed;
    private final Integer maxNoOfRetryPollsOrTimeouts;
    private final Long pollingTime;
    private final String seek;

    @JsonCreator
    public ConsumerLocalConfigs(@JsonProperty(value="recordType") String recordType, @JsonProperty(value="fileDumpTo") String fileDumpTo, @JsonProperty(value="commitAsync") Boolean commitAsync, @JsonProperty(value="commitSync") Boolean commitSync, @JsonProperty(value="showRecordsConsumed") Boolean showRecordsConsumed, @JsonProperty(value="maxNoOfRetryPollsOrTimeouts") Integer maxNoOfRetryPollsOrTimeouts, @JsonProperty(value="pollingTime") Long pollingTime, @JsonProperty(value="seek") String seek) {
        this.recordType = recordType;
        this.fileDumpTo = fileDumpTo;
        this.commitAsync = commitAsync;
        this.commitSync = commitSync;
        this.showRecordsConsumed = showRecordsConsumed;
        this.maxNoOfRetryPollsOrTimeouts = maxNoOfRetryPollsOrTimeouts;
        this.pollingTime = pollingTime;
        this.seek = seek;
    }

    public String getRecordType() {
        return this.recordType != null ? this.recordType : "RAW";
    }

    public String getFileDumpTo() {
        return this.fileDumpTo;
    }

    public Boolean getCommitAsync() {
        return this.commitAsync;
    }

    public Boolean getCommitSync() {
        return this.commitSync;
    }

    public Boolean getShowRecordsConsumed() {
        return this.showRecordsConsumed != null ? this.showRecordsConsumed : true;
    }

    public Integer getMaxNoOfRetryPollsOrTimeouts() {
        return this.maxNoOfRetryPollsOrTimeouts;
    }

    public Long getPollingTime() {
        return this.pollingTime;
    }

    public String getSeek() {
        return this.seek;
    }

    @JsonIgnore
    public String[] getSeekTopicPartitionOffset() {
        return this.seek.split(",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerLocalConfigs that = (ConsumerLocalConfigs)o;
        return Objects.equals(this.recordType, that.recordType) && Objects.equals(this.fileDumpTo, that.fileDumpTo) && Objects.equals(this.commitAsync, that.commitAsync) && Objects.equals(this.commitSync, that.commitSync) && Objects.equals(this.showRecordsConsumed, that.showRecordsConsumed) && Objects.equals(this.maxNoOfRetryPollsOrTimeouts, that.maxNoOfRetryPollsOrTimeouts) && Objects.equals(this.pollingTime, that.pollingTime) && Objects.equals(this.seek, that.seek);
    }

    public int hashCode() {
        return Objects.hash(this.recordType, this.fileDumpTo, this.commitAsync, this.commitSync, this.showRecordsConsumed, this.maxNoOfRetryPollsOrTimeouts, this.pollingTime, this.seek);
    }

    public String toString() {
        return "ConsumerLocalConfigs{recordType='" + this.recordType + '\'' + ", fileDumpTo='" + this.fileDumpTo + '\'' + ", commitAsync=" + this.commitAsync + ", commitSync=" + this.commitSync + ", showRecordsConsumed=" + this.showRecordsConsumed + ", maxNoOfRetryPollsOrTimeouts=" + this.maxNoOfRetryPollsOrTimeouts + ", pollingTime=" + this.pollingTime + ", seek=" + this.seek + '}';
    }
}

