/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.receive;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.kafka.helper.KafkaConsumerHelper;
import org.jsmart.zerocode.core.kafka.helper.KafkaFileRecordHelper;
import org.jsmart.zerocode.core.kafka.receive.ConsumerCommonConfigs;
import org.jsmart.zerocode.core.kafka.receive.message.ConsumerJsonRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaReceiver.class);
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();
    @Inject(optional=true)
    @Named(value="kafka.consumer.properties")
    private String consumerPropertyFile;
    @Inject
    private ConsumerCommonConfigs consumerCommonConfigs;

    /*
     * Unable to fully structure code
     */
    public String receive(String kafkaServers, String topicName, String requestJsonWithConfig) throws IOException {
        consumerLocalConfigs = KafkaConsumerHelper.readConsumerLocalTestProperties(requestJsonWithConfig);
        effectiveLocal = KafkaConsumerHelper.deriveEffectiveConfigs(consumerLocalConfigs, this.consumerCommonConfigs);
        KafkaReceiver.LOGGER.info("\n### Kafka Consumer Effective configs:{}\n", (Object)effectiveLocal);
        consumer = KafkaConsumerHelper.createConsumer(kafkaServers, this.consumerPropertyFile, topicName);
        rawRecords = new ArrayList<ConsumerRecord>();
        jsonRecords = new ArrayList<ConsumerJsonRecord>();
        noOfTimeOuts = 0;
        KafkaConsumerHelper.handleSeekOffset(effectiveLocal, consumer);
        do lbl-1000:
        // 3 sources

        {
            block10: {
                KafkaReceiver.LOGGER.info("polling records  - noOfTimeOuts reached : " + noOfTimeOuts);
                records = consumer.poll(Duration.ofMillis(KafkaConsumerHelper.getPollTime(effectiveLocal)));
                ++noOfTimeOuts;
                if (records.count() != 0) break block10;
                if (noOfTimeOuts < KafkaConsumerHelper.getMaxTimeOuts(effectiveLocal)) ** GOTO lbl-1000
                break;
            }
            KafkaReceiver.LOGGER.info("Received {} records after {} timeouts\n", (Object)records.count(), (Object)noOfTimeOuts);
            if (records != null) {
                recordIterator = records.iterator();
                KafkaReceiver.LOGGER.info("Consumer chosen recordType: " + effectiveLocal.getRecordType());
                var12_12 = effectiveLocal.getRecordType();
                var13_13 = -1;
                switch (var12_12.hashCode()) {
                    case 80904: {
                        if (!var12_12.equals("RAW")) break;
                        var13_13 = 0;
                        break;
                    }
                    case 2286824: {
                        if (!var12_12.equals("JSON")) break;
                        var13_13 = 1;
                    }
                }
                switch (var13_13) {
                    case 0: {
                        KafkaConsumerHelper.readRaw(rawRecords, recordIterator);
                        break;
                    }
                    case 1: {
                        KafkaConsumerHelper.readJson(jsonRecords, recordIterator);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported record type - '" + effectiveLocal.getRecordType() + "'. Supported values are 'JSON','RAW'");
                    }
                }
            }
            KafkaConsumerHelper.handleCommitSyncAsync((Consumer<Long, String>)consumer, this.consumerCommonConfigs, effectiveLocal);
        } while (noOfTimeOuts < KafkaConsumerHelper.getMaxTimeOuts(effectiveLocal));
        consumer.close();
        KafkaFileRecordHelper.handleRecordsDump(effectiveLocal, rawRecords, jsonRecords);
        return KafkaConsumerHelper.prepareResult(effectiveLocal, jsonRecords, rawRecords);
    }
}

