/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientRequest;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperJsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelperJsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapperProvider().get();

    public static String getContentAsItIsJson(Object bodyContent) {
        if (null == bodyContent) {
            return null;
        }
        try {
            String bodyContentAsString = mapper.writeValueAsString(bodyContent);
            JsonNode bodyJsonNode = (JsonNode)mapper.readValue(bodyContentAsString, JsonNode.class);
            if (bodyJsonNode.isValueNode()) {
                return bodyJsonNode.asText();
            }
            if (bodyJsonNode.size() == 0) {
                return null;
            }
            return bodyJsonNode.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> readObjectAsMap(Object jsonContent) {
        HashMap<String, Object> map = new HashMap();
        try {
            map = (Map)mapper.readValue(jsonContent.toString(), HashMap.class);
        }
        catch (IOException exx) {
            LOGGER.error("Exception occurred during parse to HashMap - " + exx);
            throw new RuntimeException(exx);
        }
        return map;
    }

    public static String createAndReturnAssertionResultJson(int httpResponseCode, String resultBodyContent, String locationHref) {
        LOGGER.debug("\n#locationHref: " + locationHref);
        if (StringUtils.isEmpty((String)resultBodyContent)) {
            resultBodyContent = "{}";
        }
        String locationField = locationHref != null ? "\t\"Location\" : \"" + locationHref + "\",\n" : "";
        String assertJson = "{\n\t\"status\" : " + httpResponseCode + ",\n" + locationField + "\t\"body\" : " + resultBodyContent + "\n" + " }";
        String formattedStr = SmartUtils.prettyPrintJson(assertJson);
        return formattedStr;
    }

    private void setRequestHeaders(Object headers, ClientRequest clientExecutor) {
        Map<String, Object> headersMap = HelperJsonUtils.readObjectAsMap(headers);
        for (String key : headersMap.keySet()) {
            clientExecutor.header(key, headersMap.get(key));
        }
    }

    public static String javaObjectAsString(Object value) {
        try {
            ObjectMapper ow = new ObjectMapperProvider().get();
            return ow.writeValueAsString(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while converting IPT Java Object to JsonString" + e);
        }
    }

    public static List<FieldAssertionMatcher> strictComparePayload(String expectedResult, String actualResult) {
        List<FieldAssertionMatcher> matchers = new ArrayList<FieldAssertionMatcher>();
        String actualResultJson = HelperJsonUtils.readPayload(actualResult);
        String expectedResultJson = HelperJsonUtils.readPayload(expectedResult);
        try {
            JSONAssert.assertEquals((String)expectedResultJson, (String)actualResultJson, (JSONCompareMode)JSONCompareMode.STRICT);
        }
        catch (AssertionError scream) {
            String rawMsg = ((Throwable)((Object)scream)).getMessage();
            List<String> messageList = Arrays.asList(rawMsg.split(";"));
            matchers = messageList.stream().map(msg -> {
                List<String> strings = Arrays.asList(msg.trim().split("\n"));
                String fieldJsonPath = "";
                if (strings != null && strings.size() > 0) {
                    fieldJsonPath = strings.get(0).substring(strings.get(0).indexOf(": ") + 1).trim();
                }
                if (strings.size() == 1) {
                    return FieldAssertionMatcher.aNotMatchingMessage(fieldJsonPath, "", strings.get(0).trim());
                }
                if (strings.size() == 2) {
                    return FieldAssertionMatcher.aNotMatchingMessage(fieldJsonPath, "", strings.get(1).trim());
                }
                if (strings.size() > 2) {
                    return FieldAssertionMatcher.aNotMatchingMessage(fieldJsonPath, strings.get(1).trim(), strings.get(2).trim());
                }
                return FieldAssertionMatcher.aMatchingMessage();
            }).collect(Collectors.toList());
        }
        return matchers;
    }

    private static String readPayload(String json) {
        String bodyPath = "$.body";
        String rawBodyPath = "$.rawBody";
        Map payload = (Map)HelperJsonUtils.readJsonPathOrElseNull(json, bodyPath);
        payload = payload == null ? (Map)HelperJsonUtils.readJsonPathOrElseNull(json, rawBodyPath) : payload;
        try {
            return mapper.writeValueAsString((Object)payload);
        }
        catch (JsonProcessingException ex) {
            LOGGER.debug("Exception while reading payload - " + (Object)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    public static Object readJsonPathOrElseNull(String requestJson, String jsonPath) {
        try {
            return JsonPath.read((String)requestJson, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pEx) {
            LOGGER.debug("No " + jsonPath + " was present in the request. returned null.");
            return null;
        }
    }
}

