/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.preprocessor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessor;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.jsmart.zerocode.core.utils.TokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeExternalFileProcessorImpl
implements ZeroCodeExternalFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeExternalFileProcessorImpl.class);
    private final ObjectMapper objectMapper;

    @Inject
    public ZeroCodeExternalFileProcessorImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Step resolveExtJsonFile(Step thisStep) {
        try {
            if (!this.checkDigNeeded(thisStep)) {
                return thisStep;
            }
            JsonNode stepNode = (JsonNode)this.objectMapper.convertValue((Object)thisStep, JsonNode.class);
            Map stepMap = (Map)this.objectMapper.readValue(stepNode.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.digReplaceContent(stepMap);
            JsonNode jsonStepNode = this.objectMapper.valueToTree((Object)stepMap);
            return (Step)this.objectMapper.treeToValue((TreeNode)jsonStepNode, Step.class);
        }
        catch (Exception exx) {
            LOGGER.error("External file reading exception - {}", (Object)exx.getMessage());
            throw new RuntimeException("External file reading exception. Details - " + exx);
        }
    }

    @Override
    public List<Step> createFromStepFile(Step thisStep, String stepId) {
        ArrayList<Step> thisSteps = new ArrayList<Step>();
        if (thisStep.getStepFile() != null) {
            try {
                thisSteps.add((Step)this.objectMapper.treeToValue((TreeNode)thisStep.getStepFile(), Step.class));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("\n### Error while parsing for stepId - {}, stepFile - {}", (Object)stepId, (Object)thisStep.getStepFile());
                throw new RuntimeException(e);
            }
        }
        if (null != thisStep.getStepFiles() && !thisStep.getStepFiles().isEmpty()) {
            try {
                for (int i = 0; i < thisStep.getStepFiles().size(); ++i) {
                    thisSteps.add((Step)this.objectMapper.treeToValue((TreeNode)thisStep.getStepFiles().get(i), Step.class));
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.error("\n### Error while parsing for stepId - {}, stepFile - {}", (Object)stepId, thisStep.getStepFiles());
                throw new RuntimeException(e);
            }
        }
        return thisSteps;
    }

    void digReplaceContent(Map<String, Object> map) {
        map.entrySet().stream().forEach(entry -> {
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.digReplaceContent((Map)value);
            } else {
                LOGGER.debug("Leaf node found = {}, checking for any external json file...", value);
                if (value != null && value.toString().contains("JSON.FILE:")) {
                    LOGGER.info("Found external JSON file place holder = {}. Replacing with content", value);
                    String valueString = value.toString();
                    String token = this.getJsonFilePhToken(valueString);
                    if (token != null && token.startsWith("JSON.FILE:")) {
                        String resourceJsonFile = token.substring("JSON.FILE:".length());
                        try {
                            JsonNode jsonNode = this.objectMapper.readTree(SmartUtils.readJsonAsString(resourceJsonFile));
                            if (jsonNode.isObject()) {
                                Map jsonFileContent = (Map)this.objectMapper.convertValue((Object)jsonNode, Map.class);
                                this.digReplaceContent(jsonFileContent);
                                jsonNode = (JsonNode)this.objectMapper.convertValue((Object)jsonFileContent, JsonNode.class);
                            }
                            entry.setValue(jsonNode);
                        }
                        catch (Exception exx) {
                            LOGGER.error("External file reference exception - {}", (Object)exx.getMessage());
                            throw new RuntimeException(exx);
                        }
                    }
                }
            }
        });
    }

    private String getJsonFilePhToken(String valueString) {
        List<String> allTokens;
        if (valueString != null && (allTokens = TokenUtils.getTestCaseTokens(valueString)) != null && !allTokens.isEmpty()) {
            return allTokens.get(0);
        }
        return null;
    }

    boolean checkDigNeeded(Step thisStep) throws JsonProcessingException {
        String stepJson = this.objectMapper.writeValueAsString((Object)thisStep);
        List<String> allTokens = TokenUtils.getTestCaseTokens(stepJson);
        return allTokens.toString().contains("JSON.FILE:");
    }
}

