/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.preprocessor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.univocity.parsers.csv.CsvParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.constants.ZerocodeConstants;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeParameterizedProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeParameterizedProcessorImpl
implements ZeroCodeParameterizedProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeParameterizedProcessorImpl.class);
    public static final String VALUE_SOURCE_KEY = "0";
    private final ObjectMapper objectMapper;
    private final CsvParser csvParser;

    @Inject
    public ZeroCodeParameterizedProcessorImpl(ObjectMapper objectMapper, CsvParser csvParser) {
        this.objectMapper = objectMapper;
        this.csvParser = csvParser;
    }

    @Override
    public ScenarioSpec resolveParameterized(ScenarioSpec scenario, int iteration) {
        if (scenario.getParameterized() == null) {
            return scenario;
        }
        if (scenario.getParameterized().getValueSource() != null) {
            return this.resolveParamsValues(scenario, iteration);
        }
        if (scenario.getParameterized().getCsvSource() != null) {
            return this.resolveParamsCsv(scenario, iteration);
        }
        throw new RuntimeException("Scenario spec was invalid. Please check the DSL format \ne.g. \n" + ZerocodeConstants.DSL_FORMAT);
    }

    private ScenarioSpec resolveParamsValues(ScenarioSpec scenario, int paramIndex) {
        LOGGER.info("Resolving parameter value-source for index - {}", (Object)paramIndex);
        try {
            String stepJson = this.objectMapper.writeValueAsString((Object)scenario);
            List<Object> parameterized = scenario.getParameterized().getValueSource();
            if (parameterized == null || parameterized.isEmpty()) {
                return scenario;
            }
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put(VALUE_SOURCE_KEY, parameterized.get(paramIndex));
            String resultantStepJson = this.replaceWithValues(stepJson, valuesMap);
            return (ScenarioSpec)this.objectMapper.readValue(resultantStepJson, ScenarioSpec.class);
        }
        catch (Exception exx) {
            throw new RuntimeException("Error while resolving parameterized values for a scenario - " + exx);
        }
    }

    private ScenarioSpec resolveParamsCsv(ScenarioSpec scenario, int paramIndex) {
        LOGGER.info("Resolving parameter CSV-source for row number - {}", (Object)paramIndex);
        try {
            String stepJson = this.objectMapper.writeValueAsString((Object)scenario);
            List<String> parameterizedCsvList = scenario.getParameterized().getCsvSource();
            if (parameterizedCsvList == null || parameterizedCsvList.isEmpty()) {
                return scenario;
            }
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            String csvLine = parameterizedCsvList.get(paramIndex);
            this.resolveCsvLine(valuesMap, csvLine);
            String resultantStepJson = this.replaceWithValues(stepJson, valuesMap);
            return (ScenarioSpec)this.objectMapper.readValue(resultantStepJson, ScenarioSpec.class);
        }
        catch (Exception exx) {
            throw new RuntimeException("Error while resolving parameterizedCsv values - " + exx);
        }
    }

    private void resolveCsvLine(Map<String, Object> valuesMap, String csvLine) {
        String[] parsedLine = this.csvParser.parseLine(csvLine + "\n");
        AtomicLong index = new AtomicLong(0L);
        Arrays.stream(parsedLine).forEach(thisValue -> valuesMap.put(index.getAndIncrement() + "", thisValue));
    }

    private String replaceWithValues(String stepJson, Map<String, Object> valuesMap) {
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(stepJson);
    }
}

