/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.send;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jsmart.zerocode.core.di.provider.GsonSerDeProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.engine.preprocessor.ScenarioExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessorImpl;
import org.jsmart.zerocode.core.kafka.delivery.DeliveryDetails;
import org.jsmart.zerocode.core.kafka.helper.KafkaProducerHelper;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecord;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecords;
import org.jsmart.zerocode.core.kafka.send.message.ProducerRawRecords;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSender.class);
    @Inject(optional=true)
    @Named(value="kafka.producer.properties")
    private String producerPropertyFile;
    @Inject
    private ZeroCodeAssertionsProcessorImpl zeroCodeAssertionsProcessor;
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();
    private final Gson gson = new GsonSerDeProvider().get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String send(String brokers, String topicName, String requestJson, ScenarioExecutionState scenarioExecutionState) throws JsonProcessingException {
        producer = KafkaProducerHelper.createProducer(brokers, this.producerPropertyFile);
        deliveryDetails = null;
        recordType = KafkaProducerHelper.readRecordType(requestJson, "$.recordType");
        try {
            var10_8 = recordType;
            var11_10 = -1;
            switch (var10_8.hashCode()) {
                case 80904: {
                    if (!var10_8.equals("RAW")) break;
                    var11_10 = 0;
                    break;
                }
                case 76403144: {
                    if (!var10_8.equals("PROTO")) break;
                    var11_10 = 1;
                    break;
                }
                case 2286824: {
                    if (!var10_8.equals("JSON")) break;
                    var11_10 = 2;
                }
            }
            switch (var11_10) {
                case 0: {
                    rawRecords = (ProducerRawRecords)this.gson.fromJson(requestJson, ProducerRawRecords.class);
                    fileName = rawRecords.getFile();
                    if (fileName == null) ** GOTO lbl66
                    file = this.validateAndGetFile(fileName);
                    try {
                        br = new BufferedReader(new FileReader(file));
                        var15_25 = null;
                        i = 0;
                        while ((line = br.readLine()) != null) {
                            record = (ProducerRecord)this.gson.fromJson(line, ProducerRecord.class);
                            KafkaSender.LOGGER.info("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                            deliveryDetails = this.sendRaw(topicName, producer, record, rawRecords.getAsync());
                            ++i;
                        }
                        if (br == null) break;
                        if (var15_25 == null) ** GOTO lbl46
                        try {
                            br.close();
                            ** break;
lbl41:
                            // 1 sources

                        }
                        catch (Throwable line) {
                            var15_25.addSuppressed(line);
                            ** break;
                        }
lbl45:
                        // 1 sources

                        break;
lbl46:
                        // 1 sources

                        br.close();
                        ** break;
lbl48:
                        // 1 sources

                        break;
                        catch (Throwable line) {
                            try {
                                var15_25 = line;
                                throw line;
                            }
                            catch (Throwable var19_37) {
                                if (br != null) {
                                    if (var15_25 != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (Throwable var20_38) {
                                            var15_25.addSuppressed(var20_38);
                                        }
                                    } else {
                                        br.close();
                                    }
                                }
                                throw var19_37;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException(ex);
                    }
lbl66:
                    // 1 sources

                    records = rawRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (i = 0; i < records.size(); ++i) {
                        KafkaSender.LOGGER.info("Sending record number: {}\n", (Object)i);
                        deliveryDetails = this.sendRaw(topicName, producer, records.get(i), rawRecords.getAsync());
                    }
                    break;
                }
                case 1: 
                case 2: {
                    jsonRecords = (ProducerJsonRecords)this.objectMapper.readValue(requestJson, ProducerJsonRecords.class);
                    fileName = jsonRecords.getFile();
                    if (fileName == null) ** GOTO lbl117
                    file = this.validateAndGetFile(fileName);
                    br = new BufferedReader(new FileReader(file));
                    var15_26 = null;
                    i = 0;
                    while ((line = br.readLine()) != null) {
                        line = this.zeroCodeAssertionsProcessor.resolveStringJson(line, scenarioExecutionState.getResolvedScenarioState());
                        record = (ProducerJsonRecord)this.objectMapper.readValue(line, ProducerJsonRecord.class);
                        KafkaSender.LOGGER.info("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                        deliveryDetails = this.sendJson(topicName, producer, record, jsonRecords.getAsync(), recordType, requestJson);
                        ++i;
                    }
                    if (br == null) break;
                    if (var15_26 == null) ** GOTO lbl99
                    try {
                        br.close();
                        ** break;
lbl94:
                        // 1 sources

                    }
                    catch (Throwable var16_33) {
                        var15_26.addSuppressed(var16_33);
                        ** break;
                    }
lbl98:
                    // 1 sources

                    break;
lbl99:
                    // 1 sources

                    br.close();
                    ** break;
lbl101:
                    // 1 sources

                    break;
                    catch (Throwable var16_34) {
                        try {
                            var15_26 = var16_34;
                            throw var16_34;
                        }
                        catch (Throwable var21_40) {
                            if (br != null) {
                                if (var15_26 != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable var22_41) {
                                        var15_26.addSuppressed(var22_41);
                                    }
                                } else {
                                    br.close();
                                }
                            }
                            throw var21_40;
                        }
                    }
lbl117:
                    // 1 sources

                    records = jsonRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (i = 0; i < records.size(); ++i) {
                        deliveryDetails = this.sendJson(topicName, producer, records.get(i), jsonRecords.getAsync(), recordType, requestJson);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported recordType '" + recordType + "'. Chose RAW or JSON");
                }
            }
        }
        catch (Exception e) {
            KafkaSender.LOGGER.error("Error in sending record.", (Throwable)e);
            failedStatus = this.objectMapper.writeValueAsString((Object)new DeliveryDetails("Failed", e.getMessage()));
            var12_15 = SmartUtils.prettyPrintJson(failedStatus);
            return var12_15;
        }
        finally {
            producer.close();
        }
        return SmartUtils.prettyPrintJson(deliveryDetails);
    }

    private String sendRaw(String topicName, Producer<?, ?> producer, ProducerRecord recordToSend, Boolean isAsync) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord qualifiedRecord = KafkaProducerHelper.prepareRecordToSend(topicName, recordToSend);
        if (Boolean.TRUE.equals(isAsync)) {
            LOGGER.info("Asynchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.info("Synchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord).get();
        }
        LOGGER.info("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.info("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private String sendJson(String topicName, Producer<?, ?> producer, ProducerJsonRecord recordToSend, Boolean isAsync, String recordType, String requestJson) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord<Object, Object> record = KafkaProducerHelper.prepareJsonRecordToSend(topicName, recordToSend, recordType, requestJson);
        if (Boolean.TRUE.equals(isAsync)) {
            LOGGER.info("Asynchronous - Producer sending JSON record - {}", record);
            metadata = (RecordMetadata)producer.send(record, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.info("Producer sending JSON record - {}", record);
            metadata = (RecordMetadata)producer.send(record).get();
        }
        LOGGER.info("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.info("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private File validateAndGetFile(String fileName) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            return new File(resource.getFile());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error accessing file: `" + fileName + "' - " + ex);
        }
    }

    class ProducerAsyncCallback
    implements Callback {
        ProducerAsyncCallback() {
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception ex) {
            if (ex != null) {
                LOGGER.error("Asynchronous Producer failed with exception - {} ", (Throwable)ex);
            } else {
                LOGGER.info("Asynchronous Producer call was successful");
            }
        }
    }
}

