/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.engine.tokens.ZeroCodeValueTokens;
import org.jsmart.zerocode.core.utils.FixedLengthRandomGenerator;
import org.jsmart.zerocode.core.utils.RandomNumberGenerator;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.jsmart.zerocode.core.utils.UUIDGenerator;

public class TokenUtils {
    public static String resolveKnownTokens(String requestJsonOrAnyString) {
        HashMap paramMap = new HashMap();
        List<String> testCaseTokens = TokenUtils.getTestCaseTokens(requestJsonOrAnyString);
        testCaseTokens.stream().distinct().forEach(runTimeToken -> TokenUtils.populateParamMap(paramMap, runTimeToken));
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(requestJsonOrAnyString);
    }

    public static void populateParamMap(Map<String, Object> paramaMap, String runTimeToken) {
        ZeroCodeValueTokens.getKnownTokens().forEach(inStoreToken -> {
            if (runTimeToken.startsWith((String)inStoreToken)) {
                if (runTimeToken.startsWith("RANDOM.NUMBER")) {
                    String[] slices = runTimeToken.split(":");
                    if (slices.length == 2) {
                        if (runTimeToken.startsWith("RANDOM.NUMBER.FIXED")) {
                            paramaMap.put(runTimeToken, FixedLengthRandomGenerator.getGenerator(Integer.parseInt(slices[1])).toString());
                        } else {
                            paramaMap.put(runTimeToken, FixedLengthRandomGenerator.getGenerator(Integer.parseInt(slices[1])));
                        }
                    } else if (runTimeToken.equals("RANDOM.NUMBER.FIXED")) {
                        paramaMap.put(runTimeToken, new RandomNumberGenerator().toString());
                    } else {
                        paramaMap.put(runTimeToken, new RandomNumberGenerator());
                    }
                } else if (runTimeToken.startsWith("RANDOM.STRING:")) {
                    int length = Integer.parseInt(runTimeToken.substring("RANDOM.STRING:".length()));
                    paramaMap.put(runTimeToken, TokenUtils.createRandomAlphaString(length));
                } else if (runTimeToken.startsWith("RANDOM.ALPHANUMERIC:")) {
                    int length = Integer.parseInt(runTimeToken.substring("RANDOM.ALPHANUMERIC:".length()));
                    paramaMap.put(runTimeToken, TokenUtils.createRandomAlphaNumericString(length));
                } else if (runTimeToken.startsWith("STATIC.ALPHABET:")) {
                    int length = Integer.parseInt(runTimeToken.substring("STATIC.ALPHABET:".length()));
                    paramaMap.put(runTimeToken, TokenUtils.createStaticAlphaString(length));
                } else if (runTimeToken.startsWith("LOCAL.DATE.TODAY:")) {
                    String formatPattern = runTimeToken.substring("LOCAL.DATE.TODAY:".length());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                    paramaMap.put(runTimeToken, LocalDate.now().format(formatter));
                } else if (runTimeToken.startsWith("LOCAL.DATETIME.NOW:")) {
                    String formatPattern = runTimeToken.substring("LOCAL.DATETIME.NOW:".length());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                    paramaMap.put(runTimeToken, LocalDateTime.now().format(formatter));
                } else if (runTimeToken.startsWith("SYSTEM.PROPERTY:")) {
                    String propertyName = runTimeToken.substring("SYSTEM.PROPERTY:".length());
                    paramaMap.put(runTimeToken, System.getProperty(propertyName));
                } else if (runTimeToken.startsWith("SYSTEM.ENV:")) {
                    String propertyName = runTimeToken.substring("SYSTEM.ENV:".length());
                    paramaMap.put(runTimeToken, System.getenv(propertyName));
                } else if (runTimeToken.startsWith("XML.FILE:")) {
                    String xmlFileResource = runTimeToken.substring("XML.FILE:".length());
                    String xmlString = TokenUtils.getXmlContent(xmlFileResource);
                    paramaMap.put(runTimeToken, StringEscapeUtils.escapeJava((String)xmlString));
                } else if (runTimeToken.startsWith("GQL.FILE:")) {
                    String gqlFileResource = runTimeToken.substring("GQL.FILE:".length());
                    String gqlString = TokenUtils.getXmlContent(gqlFileResource);
                    paramaMap.put(runTimeToken, StringEscapeUtils.escapeJava((String)gqlString));
                } else if (runTimeToken.startsWith("RANDOM.UUID")) {
                    if (runTimeToken.equals("RANDOM.UUID.FIXED")) {
                        paramaMap.put(runTimeToken, UUID.randomUUID().toString());
                    } else {
                        paramaMap.put(runTimeToken, new UUIDGenerator());
                    }
                } else if (runTimeToken.startsWith("ABS.PATH:")) {
                    String propertyName = runTimeToken.substring("ABS.PATH:".length());
                    paramaMap.put(runTimeToken, TokenUtils.absolutePathOf(propertyName));
                }
            }
        });
    }

    public static List<String> getTestCaseTokens(String aString) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(aString);
        ArrayList<String> keyTokens = new ArrayList<String>();
        while (matcher.find()) {
            keyTokens.add(matcher.group(1));
        }
        return keyTokens;
    }

    public static String createRandomAlphaString(int length) {
        return RandomStringUtils.randomAlphabetic((int)length);
    }

    public static String createRandomAlphaNumericString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static String createStaticAlphaString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + i));
            i = i >= 26 ? 0 : i;
        }
        return builder.toString();
    }

    public static String getXmlContent(String xmlFileResource) {
        try {
            return SmartUtils.readJsonAsString(xmlFileResource);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Oops! Problem occurred while reading the XML file '" + xmlFileResource + "', details:" + e);
        }
    }

    public static String absolutePathOf(String resourceFilePath) {
        URL res = TokenUtils.class.getClassLoader().getResource(resourceFilePath);
        if (res == null) {
            throw new RuntimeException("Wrong file name or path found '" + resourceFilePath + "', Please fix it and rerun.");
        }
        File file = null;
        try {
            file = Paths.get(res.toURI()).toFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong while fetching abs path of '" + resourceFilePath + "', " + "Please recheck the file/path. Full exception is : " + e);
        }
        return file.getAbsolutePath();
    }
}

