/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.listener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeTestReportListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeTestReportListener.class);
    private final ObjectMapper mapper;
    private final ZeroCodeReportGenerator reportGenerator;

    @Inject
    public ZeroCodeTestReportListener(ObjectMapper mapper, ZeroCodeReportGenerator injectedReportGenerator) {
        this.mapper = mapper;
        this.reportGenerator = injectedReportGenerator;
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result result) {
        this.printTestCompleted();
        this.generateChartsAndReports();
        this.runPostFinished();
    }

    private void printTestCompleted() {
        LOGGER.info("#ZeroCode: Test run completed for this runner. Generating test reports and charts. \n* For more examples and help on automated Kafka data stream testing and Load testing visit https://zerocode.io");
    }

    public void runPostFinished() {
    }

    private void generateChartsAndReports() {
        this.reportGenerator.generateCsvReport();
        this.reportGenerator.generateExtentReport();
    }
}

