/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.jsmart.zerocode.core.httpclient.utils.FileUploadUtils;
import org.jsmart.zerocode.core.httpclient.utils.HeaderUtils;
import org.jsmart.zerocode.core.httpclient.utils.UrlQueryParamsUtils;
import org.jsmart.zerocode.core.utils.HelperJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHttpClient {
    Logger LOGGER = LoggerFactory.getLogger(BasicHttpClient.class);
    public static final String FILES_FIELD = "files";
    public static final String BOUNDARY_FIELD = "boundary";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE = "Content-Type";
    private Object COOKIE_JSESSIONID_VALUE;
    private CloseableHttpClient httpclient;

    public BasicHttpClient() {
    }

    public BasicHttpClient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public CloseableHttpClient createHttpClient() throws Exception {
        this.LOGGER.info("###Creating SSL Enabled Http Client for both http/https/TLS connections");
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    public Response execute(String httpUrl, String methodName, Map<String, Object> headers, Map<String, Object> queryParams, Object body) throws Exception {
        this.httpclient = this.createHttpClient();
        String reqBodyAsString = this.handleRequestBody(body);
        httpUrl = this.handleUrlAndQueryParams(httpUrl, queryParams);
        RequestBuilder requestBuilder = this.createRequestBuilder(httpUrl, methodName, headers, reqBodyAsString);
        this.handleHeaders(headers, requestBuilder);
        this.addCookieToHeader(requestBuilder);
        CloseableHttpResponse httpResponse = this.httpclient.execute(requestBuilder.build());
        return this.handleResponse(httpResponse);
    }

    public Response handleResponse(CloseableHttpResponse httpResponse) throws IOException {
        Response serverResponse = this.createCharsetResponse(httpResponse);
        Header[] allHeaders = httpResponse.getAllHeaders();
        Response.ResponseBuilder responseBuilder = Response.fromResponse((Response)serverResponse);
        for (Header thisHeader : allHeaders) {
            String headerKey = thisHeader.getName();
            responseBuilder = responseBuilder.header(headerKey, (Object)thisHeader.getValue());
            this.handleHttpSession(serverResponse, headerKey);
        }
        return responseBuilder.build();
    }

    public Response createCharsetResponse(CloseableHttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        Charset charset = ContentType.getOrDefault((HttpEntity)httpResponse.getEntity()).getCharset();
        charset = charset == null ? Charset.defaultCharset() : charset;
        return Response.status((int)httpResponse.getStatusLine().getStatusCode()).entity(entity != null ? IOUtils.toString((InputStream)entity.getContent(), (Charset)charset) : null).build();
    }

    public String handleUrlAndQueryParams(String httpUrl, Map<String, Object> queryParams) throws URISyntaxException {
        if (queryParams != null && !queryParams.isEmpty()) {
            httpUrl = UrlQueryParamsUtils.setQueryParams(httpUrl, queryParams);
        }
        return httpUrl;
    }

    public RequestBuilder handleHeaders(Map<String, Object> headers, RequestBuilder requestBuilder) {
        Map<String, Object> amendedHeaders = this.amendRequestHeaders(headers);
        HeaderUtils.processFrameworkDefault(amendedHeaders, requestBuilder);
        return requestBuilder;
    }

    public Map<String, Object> amendRequestHeaders(Map<String, Object> headers) {
        return headers;
    }

    public String handleRequestBody(Object body) {
        return HelperJsonUtils.getContentAsItIsJson(body);
    }

    public RequestBuilder createDefaultRequestBuilder(String httpUrl, String methodName, String reqBodyAsString) {
        RequestBuilder requestBuilder = RequestBuilder.create((String)methodName).setUri(httpUrl);
        if (reqBodyAsString != null) {
            HttpEntity httpEntity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(reqBodyAsString).build();
            requestBuilder.setEntity(httpEntity);
        }
        return requestBuilder;
    }

    public RequestBuilder createFormUrlEncodedRequestBuilder(String httpUrl, String methodName, String reqBodyAsString) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.create((String)methodName).setUri(httpUrl);
        if (reqBodyAsString != null) {
            Map<String, Object> reqBodyMap = HelperJsonUtils.readObjectAsMap(reqBodyAsString);
            ArrayList<BasicNameValuePair> reqBody = new ArrayList<BasicNameValuePair>();
            for (String key : reqBodyMap.keySet()) {
                reqBody.add(new BasicNameValuePair(key, reqBodyMap.get(key).toString()));
            }
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(reqBody);
            requestBuilder.setEntity((HttpEntity)httpEntity);
            requestBuilder.setHeader(CONTENT_TYPE, APPLICATION_FORM_URL_ENCODED);
        }
        return requestBuilder;
    }

    public RequestBuilder createFileUploadRequestBuilder(String httpUrl, String methodName, String reqBodyAsString) throws IOException {
        Map<String, Object> fileFieldNameValueMap = FileUploadUtils.getFileFieldNameValue(reqBodyAsString);
        List fileFieldsList = (List)fileFieldNameValueMap.get(FILES_FIELD);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (fileFieldsList != null) {
            FileUploadUtils.buildAllFilesToUpload(fileFieldsList, multipartEntityBuilder);
        }
        FileUploadUtils.buildOtherRequestParams(fileFieldNameValueMap, multipartEntityBuilder);
        FileUploadUtils.buildMultiPartBoundary(fileFieldNameValueMap, multipartEntityBuilder);
        return FileUploadUtils.createUploadRequestBuilder(httpUrl, methodName, multipartEntityBuilder);
    }

    public void handleHttpSession(Response serverResponse, String headerKey) {
        if ("Set-Cookie".equals(headerKey)) {
            this.COOKIE_JSESSIONID_VALUE = serverResponse.getMetadata().get((Object)headerKey);
        }
    }

    private void addCookieToHeader(RequestBuilder uploadRequestBuilder) {
        if (this.COOKIE_JSESSIONID_VALUE != null) {
            uploadRequestBuilder.addHeader("Cookie", (String)this.COOKIE_JSESSIONID_VALUE);
        }
    }

    public RequestBuilder createRequestBuilder(String httpUrl, String methodName, Map<String, Object> headers, String reqBodyAsString) throws IOException {
        String contentType;
        String string = contentType = headers != null ? (String)headers.get(CONTENT_TYPE) : null;
        if (contentType != null) {
            if (contentType.equals(MULTIPART_FORM_DATA)) {
                return this.createFileUploadRequestBuilder(httpUrl, methodName, reqBodyAsString);
            }
            if (contentType.equals(APPLICATION_FORM_URL_ENCODED)) {
                return this.createFormUrlEncodedRequestBuilder(httpUrl, methodName, reqBodyAsString);
            }
        }
        return this.createDefaultRequestBuilder(httpUrl, methodName, reqBodyAsString);
    }
}

