/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;

public class FileUploadUtils {
    public static RequestBuilder createUploadRequestBuilder(String httpUrl, String methodName, MultipartEntityBuilder multipartEntityBuilder) {
        RequestBuilder uploadRequestBuilder = RequestBuilder.create((String)methodName).setUri(httpUrl);
        HttpEntity reqEntity = multipartEntityBuilder.build();
        uploadRequestBuilder.setEntity(reqEntity);
        return uploadRequestBuilder;
    }

    public static void buildMultiPartBoundary(Map<String, Object> fileFieldNameValueMap, MultipartEntityBuilder multipartEntityBuilder) {
        String boundary = (String)fileFieldNameValueMap.get("boundary");
        multipartEntityBuilder.setBoundary(boundary != null ? boundary : System.currentTimeMillis() + LocalDateTime.now().toString());
    }

    public static void buildAllFilesToUpload(List<String> fileFiledsList, MultipartEntityBuilder multipartEntityBuilder) {
        fileFiledsList.forEach(fileField -> {
            String[] fieldNameValue = fileField.split(":");
            String fieldName = fieldNameValue[0];
            String fileNameWithPath = fieldNameValue[1].trim();
            FileBody fileBody = new FileBody(new File(FileUploadUtils.getAbsPath(fileNameWithPath)));
            multipartEntityBuilder.addPart(fieldName, (ContentBody)fileBody);
        });
    }

    public static void buildOtherRequestParams(Map<String, Object> fileFieldNameValueMap, MultipartEntityBuilder multipartEntityBuilder) {
        for (Map.Entry<String, Object> entry : fileFieldNameValueMap.entrySet()) {
            if (entry.getKey().equals("files") || entry.getKey().equals("boundary")) continue;
            multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.TEXT_PLAIN));
        }
    }

    public static Map<String, Object> getFileFieldNameValue(String reqBodyAsString) throws IOException {
        return (Map)new ObjectMapperProvider().get().readValue(reqBodyAsString, HashMap.class);
    }

    public static String getAbsPath(String filePath) {
        if (new File(filePath).exists()) {
            return filePath;
        }
        ClassLoader classLoader = FileUploadUtils.class.getClassLoader();
        URL resource = classLoader.getResource(filePath);
        if (resource == null) {
            throw new RuntimeException("Could not get details of file or folder - `" + filePath + "`, does this exist?");
        }
        return resource.getPath();
    }
}

