/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.EnvProperty;
import org.jsmart.zerocode.core.domain.Parameterized;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.domain.TestMapping;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.jsmart.zerocode.core.utils.TokenUtils;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerUtils.class);
    public static final int MIN_COUNT = 1;

    public static String getEnvSpecificConfigFile(String serverEnv, Class<?> testClass) {
        LOGGER.info("### testClass : " + testClass);
        EnvProperty envProperty = testClass.getAnnotation(EnvProperty.class);
        if (envProperty == null) {
            return serverEnv;
        }
        String envPropNameWithPrefix = envProperty.value();
        List<String> allTokens = TokenUtils.getTestCaseTokens(envPropNameWithPrefix);
        if (allTokens.size() >= 1 && null != SmartUtils.getEnvPropertyValue(allTokens.get(0))) {
            String propertyKey = allTokens.get(0);
            String propertyValue = SmartUtils.getEnvPropertyValue(propertyKey);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(propertyKey, propertyValue);
            String resolvedEnvPropNameWithPrefix = SmartUtils.resolveToken(envPropNameWithPrefix, paramMap);
            serverEnv = RunnerUtils.suffixEnvValue(serverEnv, resolvedEnvPropNameWithPrefix);
            LOGGER.info("Found env specific property: '{}={}', Hence using: '{}'", new Object[]{propertyKey, propertyValue, serverEnv});
        } else if (allTokens.size() >= 1) {
            String propertyKey = allTokens.get(0);
            LOGGER.info("Could not find env value for env property '{}', So using '{}'", (Object)propertyKey, (Object)serverEnv);
        } else {
            LOGGER.info("Could not find env specific property, So using '{}'", (Object)serverEnv);
        }
        return serverEnv;
    }

    public static String suffixEnvValue(String serverEnv, String resolvedEnvPropNameWithPrefix) {
        String DOT_PROPERTIES = ".properties";
        return serverEnv.replace(".properties", resolvedEnvPropNameWithPrefix + ".properties");
    }

    public static String getFullyQualifiedUrl(String serviceEndPoint, String host, String port, String applicationContext) {
        if (serviceEndPoint.startsWith("http://") || serviceEndPoint.startsWith("https://")) {
            return serviceEndPoint;
        }
        if (StringUtils.isEmpty((String)port)) {
            return String.format("%s%s%s", host, applicationContext, serviceEndPoint);
        }
        return String.format("%s:%s%s%s", host, port, applicationContext, serviceEndPoint);
    }

    public static void validateTestMethod(Class<?> testClass) {
        String errMessage = " was invalid, please re-check and pick the correct test method to load.";
        try {
            TestMapping methodMapping = testClass.getAnnotation(TestMapping.class);
            errMessage = "Mapped test method `" + methodMapping.testMethod() + "`" + errMessage;
            methodMapping.testClass().getMethod(methodMapping.testMethod(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(errMessage);
            throw new RuntimeException(errMessage + e);
        }
    }

    public static int loopCount(Step thisStep) {
        int stepLoopTimes = 0;
        if (thisStep.getLoop() != null) {
            stepLoopTimes = thisStep.getLoop();
        } else if (thisStep.getParameterized() != null) {
            stepLoopTimes = thisStep.getParameterized().size();
        } else if (thisStep.getParameterizedCsv() != null) {
            stepLoopTimes = thisStep.getParameterizedCsv().size();
        }
        return stepLoopTimes > 0 ? stepLoopTimes : 1;
    }

    public static int getParameterSize(Parameterized parameterized) {
        if (parameterized == null) {
            return 0;
        }
        List<Object> valueSource = parameterized.getValueSource();
        List<String> csvSource = parameterized.getCsvSource();
        return valueSource != null ? valueSource.size() : (csvSource != null ? csvSource.size() : 0);
    }

    public static void handleTestCompleted(RunListener reportListener, Logger logger) {
        if ("gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            logger.debug("Bypassed JUnit RunListener [as configured by the build tool] to generate useful reports...");
            try {
                reportListener.testRunFinished(new Result());
            }
            catch (Exception e) {
                logger.error("### Exception occurred while handling non-maven(e.g. Gradle) report generation => " + e);
                throw new RuntimeException(e);
            }
        }
    }
}

