/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jsmart.zerocode.converter.Converter;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeConverter
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeTypeConverter.class);
    private final ObjectMapper mapper;

    @Inject
    public MimeTypeConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object xmlToJson(String xmlContent) {
        MimeTypeConverter.prettyXml(xmlContent);
        String jsonNotPretty = XML.toJSONObject((String)xmlContent).toString();
        try {
            return this.mapper.readTree(jsonNotPretty);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("XmlToJson conversion problem-  " + e.getMessage());
        }
    }

    @Override
    public Object stringToJson(String jsonString) throws IOException {
        return this.mapper.readValue(jsonString, JsonNode.class);
    }

    @Override
    public Object jsonToJson(String jsonString) throws IOException {
        return this.stringToJson(jsonString);
    }

    @Override
    public Object jsonBlockToJson(JsonNode jsonNode) {
        return jsonNode;
    }

    public static String prettyXml(String input) {
        String formattedXml = MimeTypeConverter.prettyXmlWithIndentType(input, 2);
        LOGGER.debug("\n--------------------- Pretty XML -------------------------\n" + formattedXml + "\n------------------------- * -----------------------------\n");
        return formattedXml;
    }

    public static String prettyXmlWithIndentType(String originalXml, int indentType) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(originalXml));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indentType);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(originalXml));
                StringWriter stringWriter = new StringWriter();
                StreamResult xmlOutput = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentType));
                transformer.transform(xmlInput, xmlOutput);
                return xmlOutput.getWriter().toString();
            }
            catch (Throwable t) {
                e.printStackTrace();
                return originalXml;
            }
        }
    }
}

