/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.ssl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTrustHttpClient
extends BasicHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslTrustHttpClient.class);
    public static final String HTTP_MAX_TIMEOUT_MILLISECONDS = "http.max.timeout.milliseconds";
    @Inject(optional=true)
    @Named(value="http.max.timeout.milliseconds")
    private Integer implicitWait;

    public SslTrustHttpClient() {
    }

    public SslTrustHttpClient(CloseableHttpClient httpclient) {
        super(httpclient);
    }

    @Override
    public CloseableHttpClient createHttpClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        LOGGER.debug("###Used SSL Enabled Http Client for http/https/TLS connections");
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        RequestConfig timeOutConfig = this.createMaxTimeOutConfig();
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultCookieStore((CookieStore)cookieStore).setDefaultRequestConfig(timeOutConfig).build();
    }

    private RequestConfig createMaxTimeOutConfig() {
        RequestConfig timeOutConfig;
        if (this.implicitWait == null) {
            timeOutConfig = RequestConfig.DEFAULT;
            LOGGER.debug("\n*Implicit-Wait/Connection-Timeout not configured.*\nE.g. to configure it for 10sec, use: '{}={}' in the host-config properties. \n**You can safely ignore this warning to retain the default httpClient behavior**\n", (Object)HTTP_MAX_TIMEOUT_MILLISECONDS, (Object)10000);
        } else {
            int timeout = this.implicitWait;
            timeOutConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).build();
            LOGGER.debug("\n----------------------------------------------------------------\nImplicit-Wait/Connection-Timeout config = " + this.implicitWait + " milli-second.\n----------------------------------------------------------------\n");
        }
        return timeOutConfig;
    }

    void setImplicitWait(Integer implicitWait) {
        this.implicitWait = implicitWait;
    }
}

