/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.send;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jsmart.zerocode.core.di.provider.GsonSerDeProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.engine.preprocessor.ScenarioExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessorImpl;
import org.jsmart.zerocode.core.kafka.delivery.DeliveryDetails;
import org.jsmart.zerocode.core.kafka.helper.KafkaProducerHelper;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecord;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecords;
import org.jsmart.zerocode.core.kafka.send.message.ProducerRawRecords;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSender.class);
    @Inject(optional=true)
    @Named(value="kafka.producer.properties")
    private String producerPropertyFile;
    @Inject
    private ZeroCodeAssertionsProcessorImpl zeroCodeAssertionsProcessor;
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();
    private final Gson gson = new GsonSerDeProvider().get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(String brokers, String topicName, String requestJson, ScenarioExecutionState scenarioExecutionState) throws JsonProcessingException {
        Producer<Long, String> producer = KafkaProducerHelper.createProducer(brokers, this.producerPropertyFile);
        String deliveryDetails = null;
        String recordType = KafkaProducerHelper.readRecordType(requestJson, "$.recordType");
        try {
            switch (recordType) {
                case "RAW": {
                    ProducerRawRecords rawRecords = (ProducerRawRecords)this.gson.fromJson(requestJson, ProducerRawRecords.class);
                    String fileName = rawRecords.getFile();
                    if (fileName != null) {
                        File file = this.validateAndGetFile(fileName);
                        try (BufferedReader br = new BufferedReader(new FileReader(file));){
                            String line;
                            int i = 0;
                            while ((line = br.readLine()) != null) {
                                ProducerRecord record = (ProducerRecord)this.gson.fromJson(line, ProducerRecord.class);
                                LOGGER.debug("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                                deliveryDetails = this.sendRaw(topicName, producer, record, rawRecords.getAsync());
                                ++i;
                            }
                            break;
                        }
                        catch (Throwable ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    List<ProducerRecord> records = rawRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (int i = 0; i < records.size(); ++i) {
                        LOGGER.debug("Sending record number: {}\n", (Object)i);
                        deliveryDetails = this.sendRaw(topicName, producer, records.get(i), rawRecords.getAsync());
                    }
                    break;
                }
                case "PROTO": 
                case "JSON": {
                    ProducerJsonRecords jsonRecords = (ProducerJsonRecords)this.objectMapper.readValue(requestJson, ProducerJsonRecords.class);
                    String fileName = jsonRecords.getFile();
                    if (fileName != null) {
                        File file = this.validateAndGetFile(fileName);
                        try (BufferedReader br = new BufferedReader(new FileReader(file));){
                            String line;
                            int i = 0;
                            while ((line = br.readLine()) != null) {
                                line = this.zeroCodeAssertionsProcessor.resolveStringJson(line, scenarioExecutionState.getResolvedScenarioState());
                                ProducerJsonRecord record = (ProducerJsonRecord)this.objectMapper.readValue(line, ProducerJsonRecord.class);
                                LOGGER.debug("From file:'{}', Sending record number: {}\n", (Object)fileName, (Object)i);
                                deliveryDetails = this.sendJson(topicName, producer, record, jsonRecords.getAsync(), recordType, requestJson);
                                ++i;
                            }
                            break;
                        }
                    }
                    List<ProducerJsonRecord> records = jsonRecords.getRecords();
                    KafkaProducerHelper.validateProduceRecord(records);
                    for (int i = 0; i < records.size(); ++i) {
                        deliveryDetails = this.sendJson(topicName, producer, records.get(i), jsonRecords.getAsync(), recordType, requestJson);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported recordType '" + recordType + "'. Chose RAW or JSON");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in sending record.", (Throwable)e);
            String failedStatus = this.objectMapper.writeValueAsString((Object)new DeliveryDetails("Failed", e.getMessage()));
            String string = SmartUtils.prettyPrintJson(failedStatus);
            return string;
        }
        finally {
            producer.close();
        }
        return SmartUtils.prettyPrintJson(deliveryDetails);
    }

    private String sendRaw(String topicName, Producer<?, ?> producer, ProducerRecord recordToSend, Boolean isAsync) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord qualifiedRecord = KafkaProducerHelper.prepareRecordToSend(topicName, recordToSend);
        if (Boolean.TRUE.equals(isAsync)) {
            LOGGER.debug("Asynchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.debug("Synchronous Producer sending record - {}", (Object)qualifiedRecord);
            metadata = (RecordMetadata)producer.send(qualifiedRecord).get();
        }
        LOGGER.debug("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.debug("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private String sendJson(String topicName, Producer<?, ?> producer, ProducerJsonRecord recordToSend, Boolean isAsync, String recordType, String requestJson) throws InterruptedException, ExecutionException {
        RecordMetadata metadata;
        ProducerRecord<Object, Object> record = KafkaProducerHelper.prepareJsonRecordToSend(topicName, recordToSend, recordType, requestJson);
        if (Boolean.TRUE.equals(isAsync)) {
            LOGGER.debug("Asynchronous - Producer sending JSON record - {}", record);
            metadata = (RecordMetadata)producer.send(record, (Callback)new ProducerAsyncCallback()).get();
        } else {
            LOGGER.debug("Producer sending JSON record - {}", record);
            metadata = (RecordMetadata)producer.send(record).get();
        }
        LOGGER.debug("Record was sent to partition- {}, with offset- {} ", (Object)metadata.partition(), (Object)metadata.offset());
        String deliveryDetails = this.gson.toJson((Object)new DeliveryDetails("Ok", metadata));
        LOGGER.debug("deliveryDetails- {}", (Object)deliveryDetails);
        return deliveryDetails;
    }

    private File validateAndGetFile(String fileName) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            return new File(resource.getFile());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error accessing file: `" + fileName + "' - " + ex);
        }
    }

    class ProducerAsyncCallback
    implements Callback {
        ProducerAsyncCallback() {
        }

        public void onCompletion(RecordMetadata recordMetadata, Exception ex) {
            if (ex != null) {
                LOGGER.error("Asynchronous Producer failed with exception - {} ", (Throwable)ex);
            } else {
                LOGGER.debug("Asynchronous Producer call was successful");
            }
        }
    }
}

