/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.univocity.parsers.csv.CsvParser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.CollectionUtils;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.Step;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecReportBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeIoWriteBuilder;
import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.jsmart.zerocode.core.engine.executor.ApiServiceExecutor;
import org.jsmart.zerocode.core.engine.mocker.RestEndPointMocker;
import org.jsmart.zerocode.core.engine.preprocessor.ScenarioExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.StepExecutionState;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeParameterizedProcessor;
import org.jsmart.zerocode.core.engine.sorter.ZeroCodeSorter;
import org.jsmart.zerocode.core.engine.validators.ZeroCodeValidator;
import org.jsmart.zerocode.core.kafka.helper.KafkaCommonUtils;
import org.jsmart.zerocode.core.logbuilder.ZerocodeCorrelationshipLogger;
import org.jsmart.zerocode.core.runner.StepNotificationHandler;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.utils.ApiTypeUtils;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeMultiStepsScenarioRunnerImpl
implements ZeroCodeMultiStepsScenarioRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeMultiStepsScenarioRunnerImpl.class);
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private ZeroCodeAssertionsProcessor zeroCodeAssertionsProcessor;
    @Inject
    private ZeroCodeExternalFileProcessor extFileProcessor;
    @Inject
    private ZeroCodeParameterizedProcessor parameterizedProcessor;
    @Inject
    private ZeroCodeSorter sorter;
    @Inject
    private ApiServiceExecutor apiExecutor;
    @Inject
    private CsvParser csvParser;
    @Inject
    private ApiTypeUtils apiTypeUtils;
    @Inject
    ZeroCodeValidator validator;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.host")
    private String host;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.port")
    private String port;
    @Inject(optional=true)
    @Named(value="web.application.endpoint.context")
    private String applicationContext;
    @Inject(optional=true)
    @Named(value="kafka.bootstrap.servers")
    private String kafkaServers;
    private ZerocodeCorrelationshipLogger correlLogger;
    private static StepNotificationHandler notificationHandler = new StepNotificationHandler();
    private ZeroCodeIoWriteBuilder ioWriterBuilder;
    private ZeroCodeExecReportBuilder resultReportBuilder;
    private Boolean stepOutcomeGreen;

    @Override
    public synchronized boolean runScenario(ScenarioSpec scenario, RunNotifier notifier, Description description) {
        LOGGER.warn("\n-----------------------------------------------------------------------------------\n\nScenario:\n+++++++++\n\n{} \n\n-----------------------------------------------------------------------------------", (Object)scenario.getScenarioName());
        this.ioWriterBuilder = ZeroCodeIoWriteBuilder.newInstance().timeStamp(LocalDateTime.now());
        ScenarioExecutionState scenarioExecutionState = new ScenarioExecutionState();
        int scenarioLoopTimes = this.deriveScenarioLoopTimes(scenario);
        boolean wasExecSuccessful = false;
        for (int scnCount = 0; scnCount < scenarioLoopTimes; ++scnCount) {
            LOGGER.info("{}\n     Executing Scenario Count No. or parameter No. or Row No. | {} | {}", new Object[]{"\n-------------------------------------------------------------------------", scnCount, "\n-------------------------------------------------------------------------"});
            ScenarioSpec parameterizedScenario = this.parameterizedProcessor.resolveParameterized(scenario, scnCount);
            this.resultReportBuilder = ZeroCodeExecReportBuilder.newInstance().loop(scnCount).scenarioName(parameterizedScenario.getScenarioName());
            wasExecSuccessful = this.executeSteps(notifier, description, scenarioExecutionState, parameterizedScenario);
            this.ioWriterBuilder.result(this.resultReportBuilder.build());
        }
        this.stopIfWireMockServerRunning();
        this.ioWriterBuilder.printToFile(scenario.getScenarioName() + this.correlLogger.getCorrelationId() + ".json");
        if (wasExecSuccessful) {
            return this.stepOutcomeGreen;
        }
        return true;
    }

    private boolean executeSteps(RunNotifier notifier, Description description, ScenarioExecutionState scenarioExecutionState, ScenarioSpec parameterizedScenario) {
        ScenarioSpec scenario = parameterizedScenario;
        for (Step thisStep : parameterizedScenario.getSteps()) {
            if (thisStep.getIgnoreStep()) {
                LOGGER.info("Step \"" + thisStep.getName() + "\" is ignored because of ignoreStep property.");
                continue;
            }
            this.correlLogger = ZerocodeCorrelationshipLogger.newInstance(LOGGER);
            Boolean wasExecSuccess = this.executeRetryWithSteps(notifier, description, scenarioExecutionState, scenario, thisStep);
            if (wasExecSuccess == null) continue;
            return wasExecSuccess;
        }
        return false;
    }

    private Boolean executeRetryWithSteps(RunNotifier notifier, Description description, ScenarioExecutionState scenarioExecutionState, ScenarioSpec scenario, Step thisStep) {
        thisStep = this.extFileProcessor.resolveExtJsonFile(thisStep);
        List<Step> thisSteps = this.extFileProcessor.createFromStepFile(thisStep = this.zeroCodeAssertionsProcessor.resolveJsonContent(thisStep, scenarioExecutionState), thisStep.getId());
        if (null == thisSteps || thisSteps.isEmpty()) {
            thisSteps.add(thisStep);
        }
        Boolean wasExecSuccess = null;
        for (Step step : thisSteps) {
            wasExecSuccess = this.executeRetry(notifier, description, scenarioExecutionState, scenario, step);
            if (wasExecSuccess == null) continue;
            return wasExecSuccess;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean executeRetry(RunNotifier notifier, Description description, ScenarioExecutionState scenarioExecutionState, ScenarioSpec scenario, Step thisStep) {
        String logPrefixRelationshipId = this.correlLogger.createRelationshipId();
        String executionResult = "-response unavailable-";
        String requestJsonAsString = Optional.ofNullable(thisStep.getRequest()).orElse((JsonNode)NullNode.getInstance()).toString();
        StepExecutionState stepExecutionState = new StepExecutionState();
        stepExecutionState.addStep(thisStep);
        String resolvedRequestJson = this.zeroCodeAssertionsProcessor.resolveStringJson(requestJsonAsString, scenarioExecutionState.getResolvedScenarioState());
        stepExecutionState.addRequest(resolvedRequestJson);
        boolean retryTillSuccess = false;
        int retryDelay = 0;
        int retryMaxTimes = 1;
        if (thisStep.getRetry() != null) {
            retryMaxTimes = thisStep.getRetry().getMax();
            retryDelay = thisStep.getRetry().getDelay();
            retryTillSuccess = true;
        }
        String thisStepName = thisStep.getName();
        for (int retryCounter = 0; retryCounter < retryMaxTimes; ++retryCounter) {
            if (retryCounter > 0) {
                LOGGER.warn("\n\n------------>Retrying...[step][attempt-{}][executions-{}]:'{}' -> '{}'", new Object[]{retryCounter, retryCounter + 1, scenario.getScenarioName(), thisStep.getName()});
            }
            try {
                boolean ignoreStepFailures;
                String resolvedAssertionJson;
                List<FieldAssertionMatcher> failureResults;
                if (retryCounter > 0 && !CollectionUtils.isEmpty(thisStep.getRetry().getWithSteps())) {
                    for (String stepName : thisStep.getRetry().getWithSteps()) {
                        Optional<StepExecutionState> retryWithStepExecState = scenarioExecutionState.getExecutedStepState(stepName);
                        if (!retryWithStepExecState.isPresent()) {
                            throw new RuntimeException("Invalid step to retry with : " + stepName + " has not been executed yet");
                        }
                        this.executeRetry(notifier, description, scenarioExecutionState, scenario, retryWithStepExecState.get().getStep());
                    }
                }
                executionResult = this.executeApi(logPrefixRelationshipId, thisStep, resolvedRequestJson, scenarioExecutionState);
                LocalDateTime responseTimeStamp = LocalDateTime.now();
                this.correlLogger.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStamp).response(executionResult);
                this.correlLogger.aResponseBuilder().customLog(thisStep.getCustomLog());
                stepExecutionState.addResponse(executionResult);
                scenarioExecutionState.addStepState(stepExecutionState);
                if (!Objects.isNull(thisStep.getSort())) {
                    executionResult = this.sorter.sortArrayAndReplaceInResponse(thisStep, executionResult, scenarioExecutionState.getResolvedScenarioState());
                    this.correlLogger.customLog("Updated response: " + executionResult);
                    stepExecutionState.addResponse(executionResult);
                    scenarioExecutionState.addStepState(stepExecutionState);
                }
                if (!(failureResults = this.compareStepResults(thisStep, executionResult, resolvedAssertionJson = this.zeroCodeAssertionsProcessor.resolveStringJson(Optional.ofNullable(thisStep.getAssertions()).orElse((JsonNode)NullNode.getInstance()).toString(), scenarioExecutionState.getResolvedScenarioState()), scenarioExecutionState.getResolvedScenarioState())).isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Assumed Payload: \n").append(SmartUtils.prettyPrintJson(resolvedAssertionJson)).append("\n");
                    builder.append("Assertion Errors: \n");
                    failureResults.forEach(f -> builder.append(f.toString()).append("\n"));
                    this.correlLogger.assertion(resolvedAssertionJson != null ? builder.toString() : this.expectedValidatorsAsJson(thisStep));
                } else {
                    this.correlLogger.assertion(resolvedAssertionJson != null && !"null".equalsIgnoreCase(resolvedAssertionJson) ? SmartUtils.prettyPrintJson(resolvedAssertionJson) : this.expectedValidatorsAsJson(thisStep));
                }
                if (retryTillSuccess && retryCounter + 1 < retryMaxTimes && !failureResults.isEmpty()) {
                    LOGGER.info("\n---------------------------------------\n        Retry: Attempt number: {}", (Object)(retryCounter + 2 + "\n---------------------------------------\n"));
                    this.waitForDelay(retryDelay);
                    this.stepOutcomeGreen = true;
                    continue;
                }
                boolean bl = ignoreStepFailures = scenario.getIgnoreStepFailures() == null ? false : scenario.getIgnoreStepFailures();
                if (!failureResults.isEmpty()) {
                    this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionFailed);
                    this.correlLogger.stepOutcome(this.stepOutcomeGreen);
                    if (ignoreStepFailures) {
                        this.stepOutcomeGreen = true;
                        continue;
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, failureResults, notificationHandler::handleAssertionPassed);
                this.correlLogger.stepOutcome(this.stepOutcomeGreen);
                if (!retryTillSuccess) continue;
                LOGGER.info("Retry: Leaving early with successful assertion");
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.error("###Exception while executing a step in the zerocode dsl.");
                LocalDateTime responseTimeStampEx = LocalDateTime.now();
                this.correlLogger.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(responseTimeStampEx).response(executionResult).exceptionMessage(ex.getMessage());
                this.stepOutcomeGreen = notificationHandler.handleAssertion(notifier, description, scenario.getScenarioName(), thisStepName, new RuntimeException("ZeroCode Step execution failed. Details:" + ex), notificationHandler::handleStepException);
                this.correlLogger.stepOutcome(this.stepOutcomeGreen);
                Boolean bl = true;
                return bl;
            }
            finally {
                this.correlLogger.print();
                this.resultReportBuilder.step(this.correlLogger.buildReportSingleStep());
                if (!this.stepOutcomeGreen.booleanValue()) {
                    // empty if block
                }
            }
        }
        return null;
    }

    private String expectedValidatorsAsJson(Step thisStep) throws JsonProcessingException {
        if (thisStep.getValidators() == null) {
            return "No validators were found for this step";
        }
        return SmartUtils.prettyPrintJson(this.objectMapper.writeValueAsString(thisStep.getValidators()));
    }

    private String executeApi(String logPrefixRelationshipId, Step thisStep, String resolvedRequestJson, ScenarioExecutionState scenarioExecutionState) {
        String executionResult;
        String url = thisStep.getUrl();
        String operationName = thisStep.getOperation();
        String stepId = thisStep.getId();
        String thisStepName = thisStep.getName();
        url = this.zeroCodeAssertionsProcessor.resolveStringJson(url, scenarioExecutionState.getResolvedScenarioState());
        String resolvedRequestJsonMaskRemoved = this.zeroCodeAssertionsProcessor.fieldMasksRemoved(resolvedRequestJson);
        String resolvedRequestJsonMaskApplied = this.zeroCodeAssertionsProcessor.fieldMasksApplied(resolvedRequestJson);
        LocalDateTime requestTimeStamp = LocalDateTime.now();
        switch (ApiTypeUtils.apiType(url, operationName)) {
            case REST_CALL: {
                url = RunnerUtils.getFullyQualifiedUrl(url, this.host, this.port, this.applicationContext);
                this.correlLogger.aRequestBuilder().relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(url).method(operationName).id(stepId).request(SmartUtils.prettyPrintJson(resolvedRequestJsonMaskApplied));
                executionResult = this.apiExecutor.executeHttpApi(url, operationName, resolvedRequestJsonMaskRemoved);
                break;
            }
            case JAVA_CALL: {
                this.correlLogger.aRequestBuilder().relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).id(stepId).url(url).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJsonMaskApplied));
                url = this.apiTypeUtils.getQualifiedJavaApi(url);
                executionResult = this.apiExecutor.executeJavaOperation(url, operationName, resolvedRequestJsonMaskRemoved);
                break;
            }
            case KAFKA_CALL: {
                if (this.kafkaServers == null) {
                    throw new RuntimeException(">>> 'kafka.bootstrap.servers' property can not be null for kafka operations");
                }
                KafkaCommonUtils.printBrokerProperties(this.kafkaServers);
                this.correlLogger.aRequestBuilder().relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).url(url).method(operationName.toUpperCase()).id(stepId).request(SmartUtils.prettyPrintJson(resolvedRequestJsonMaskApplied));
                String topicName = url.substring("kafka-topic:".length());
                executionResult = this.apiExecutor.executeKafkaService(this.kafkaServers, topicName, operationName, resolvedRequestJsonMaskRemoved, scenarioExecutionState);
                break;
            }
            case NONE: {
                this.correlLogger.aRequestBuilder().relationshipId(logPrefixRelationshipId).requestTimeStamp(requestTimeStamp).step(thisStepName).id(stepId).url(url).method(operationName).request(SmartUtils.prettyPrintJson(resolvedRequestJsonMaskApplied));
                executionResult = SmartUtils.prettyPrintJson(resolvedRequestJsonMaskApplied);
                break;
            }
            default: {
                throw new RuntimeException("Oops! API Type Undecided. If it is intentional, then keep the value as empty to receive the request as response");
            }
        }
        return executionResult;
    }

    private void waitForDelay(int delay) {
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean runChildStep(ScenarioSpec scenarioSpec, BiConsumer testPassHandler) {
        scenarioSpec.getSteps().forEach(step -> testPassHandler.accept(scenarioSpec.getScenarioName(), step.getName()));
        return true;
    }

    public void overridePort(int port) {
        this.port = port + "";
    }

    public void overrideHost(String host) {
        this.host = host;
    }

    public void overrideApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void stopIfWireMockServerRunning() {
        if (null != RestEndPointMocker.wireMockServer) {
            RestEndPointMocker.wireMockServer.stop();
            RestEndPointMocker.wireMockServer = null;
            LOGGER.debug("Scenario: All mockings done via WireMock server. Dependant end points executed. Stopped WireMock.");
        }
    }

    private int deriveScenarioLoopTimes(ScenarioSpec scenario) {
        int scenarioLoopTimes = scenario.getLoop() == null ? 1 : scenario.getLoop();
        int parameterSize = RunnerUtils.getParameterSize(scenario.getParameterized());
        scenarioLoopTimes = parameterSize != 0 ? parameterSize : scenarioLoopTimes;
        return scenarioLoopTimes;
    }

    private List<FieldAssertionMatcher> compareStepResults(Step thisStep, String actualResult, String expectedResult, String resolvedScenarioState) {
        List<Object> failureResults = new ArrayList();
        expectedResult = this.zeroCodeAssertionsProcessor.fieldMasksRemoved(expectedResult);
        failureResults = thisStep.getValidators() != null ? this.validator.validateFlat(thisStep, actualResult, resolvedScenarioState) : (Optional.ofNullable(thisStep.getVerifyMode()).orElse("LENIENT").equals("STRICT") ? this.validator.validateStrict(expectedResult, actualResult) : this.validator.validateLenient(expectedResult, actualResult));
        return failureResults;
    }
}

