/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;

public class FixedLengthRandomGenerator {
    private static final HashMap<Integer, FixedLengthRandomGenerator> GENERATOR_MAP = new HashMap();
    private long lowerBound;
    private long upperBound;

    private FixedLengthRandomGenerator(int length) {
        this.lowerBound = (long)Math.pow(10.0, length - 1);
        this.upperBound = (long)Math.pow(10.0, length);
    }

    public String generateRandomNumber() {
        return String.valueOf(ThreadLocalRandom.current().nextLong(this.lowerBound, this.upperBound));
    }

    public String toString() {
        return this.generateRandomNumber();
    }

    public static FixedLengthRandomGenerator getGenerator(int length) {
        if (length < 1 || length > 19) {
            throw new RuntimeException("length of the random number should be between (1-19)");
        }
        FixedLengthRandomGenerator buff = GENERATOR_MAP.get(length);
        if (buff == null) {
            buff = new FixedLengthRandomGenerator(length);
            GENERATOR_MAP.put(length, buff);
            return buff;
        }
        return buff;
    }
}

