/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jsmart.zerocode.core.utils.SmartUtils;

public class PropertiesProviderUtils {
    private static Properties properties = new Properties();

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static Properties getProperties(String propertyResourceFile) {
        InputStream inputStream = PropertiesProviderUtils.class.getClassLoader().getResourceAsStream(propertyResourceFile);
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public static Properties loadAbsoluteProperties(String host, Properties properties) {
        try {
            host = SmartUtils.replaceHome(host);
            FileInputStream inputStream = new FileInputStream(host);
            properties.load(inputStream);
            PropertiesProviderUtils.checkAndLoadOldProperties(properties);
            return properties;
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    public static void checkAndLoadOldProperties(Properties properties) {
        Object oldPropertyValue;
        if (properties.get("web.application.endpoint.host") == null && properties.get("restful.application.endpoint.host") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.host");
            properties.setProperty("web.application.endpoint.host", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
        if (properties.get("web.application.endpoint.port") == null && properties.get("restful.application.endpoint.port") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.port");
            properties.setProperty("web.application.endpoint.port", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
        if (properties.get("web.application.endpoint.context") == null && properties.get("restful.application.endpoint.context") != null) {
            oldPropertyValue = properties.get("restful.application.endpoint.context");
            properties.setProperty("web.application.endpoint.context", oldPropertyValue != null ? oldPropertyValue.toString() : null);
        }
    }
}

