/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.domain.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.domain.reports.chart.ZeroCodeChartKeyValue;

public class ZeroCodeChartKeyValueArrayBuilder {
    public static final String TEST_FAILED = "FAILED";
    List<ZeroCodeChartKeyValue> kvs = new ArrayList<ZeroCodeChartKeyValue>();

    public static ZeroCodeChartKeyValueArrayBuilder newInstance() {
        return new ZeroCodeChartKeyValueArrayBuilder();
    }

    public String build() {
        String dataRowsCommaSeparated = this.kvs.stream().map(thisRow -> {
            if (TEST_FAILED.equals(thisRow.getResult())) {
                return String.format("{name: '%s', y: %s, color: '#FF0000'}", thisRow.getKey(), thisRow.getValue());
            }
            return String.format("{name: '%s', y: %s}", thisRow.getKey(), thisRow.getValue());
        }).collect(Collectors.joining(", "));
        String dataArray = "[" + dataRowsCommaSeparated + "]";
        return dataArray;
    }

    public ZeroCodeChartKeyValueArrayBuilder kvs(List<ZeroCodeChartKeyValue> kvs) {
        this.kvs = kvs;
        return this;
    }

    public ZeroCodeChartKeyValueArrayBuilder kv(ZeroCodeChartKeyValue kv) {
        this.kvs.add(kv);
        return this;
    }
}

