/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.listener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtilityListener
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestUtilityListener.class);
    private final ObjectMapper mapper;
    private final ZeroCodeReportGenerator reportGenerator;

    @Inject
    public TestUtilityListener(ObjectMapper mapper, ZeroCodeReportGenerator injectedReportGenerator) {
        this.mapper = mapper;
        this.reportGenerator = injectedReportGenerator;
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result result) {
        this.printTestCompleted();
        this.generateChartsAndReports();
        this.runPostFinished();
    }

    private void printTestCompleted() {
        LOGGER.info("Generating test-statistics reports. please wait...");
        LOGGER.debug("#ZeroCode: Test run completed for this runner. Generating test reports... \n* For more examples, visit https://github.com/authorjapps/zerocode/wiki");
    }

    public void runPostFinished() {
    }

    private void generateChartsAndReports() {
        this.reportGenerator.generateCsvReport();
        this.reportGenerator.generateExtentReport();
    }
}

