/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.mocker;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.jsmart.zerocode.core.domain.MockStep;
import org.jsmart.zerocode.core.domain.MockSteps;
import org.jsmart.zerocode.core.engine.mocker.HandlebarsLocalDateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestEndPointMocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestEndPointMocker.class);
    public static WireMockServer wireMockServer;
    public static Boolean shouldBuildStrictUrlMatcherForAllUrls;

    private static boolean hasMoreThanOneStubForSameUrlPath(List<String> urls) {
        Set urlPathsSet = urls.stream().map(u -> u.contains("?") ? u.substring(0, u.indexOf("?")) : u).collect(Collectors.toSet());
        return urlPathsSet.size() != urls.size();
    }

    public static void createWithWireMock(MockSteps mockSteps, int mockPort) {
        RestEndPointMocker.restartWireMock(mockPort);
        List<String> urls = mockSteps.getMocks().stream().map(MockStep::getUrl).filter(Objects::nonNull).collect(Collectors.toList());
        if (urls.size() != 0 && RestEndPointMocker.hasMoreThanOneStubForSameUrlPath(urls)) {
            shouldBuildStrictUrlMatcherForAllUrls = true;
        }
        LOGGER.debug("Going to build strict url matcher - {}", (Object)shouldBuildStrictUrlMatcherForAllUrls);
        mockSteps.getMocks().forEach(mockStep -> {
            String jsonBodyRequest;
            JsonNode jsonNodeResponse = mockStep.getResponse();
            JsonNode jsonNodeBody = jsonNodeResponse.get("body");
            String string = jsonBodyRequest = jsonNodeBody != null ? jsonNodeBody.toString() : jsonNodeResponse.get("xmlBody").asText();
            if ("GET".equals(mockStep.getOperation())) {
                LOGGER.debug("*****WireMock- Mocking the GET endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createGetRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.debug("WireMock- Mocking the GET endpoint -done- *****");
            } else if ("POST".equals(mockStep.getOperation())) {
                LOGGER.debug("*****WireMock- Mocking the POST endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createPostRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.debug("WireMock- Mocking the POST endpoint -done-*****");
            } else if ("PUT".equals(mockStep.getOperation())) {
                LOGGER.debug("*****WireMock- Mocking the PUT endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createPutRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.debug("WireMock- Mocking the PUT endpoint -done-*****");
            } else if ("PATCH".equals(mockStep.getOperation())) {
                LOGGER.debug("*****WireMock- Mocking the PATCH endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createPatchRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.debug("WireMock- Mocking the PATCH endpoint -done-*****");
            } else if ("DELETE".equals(mockStep.getOperation())) {
                LOGGER.debug("*****WireMock- Mocking the DELETE endpoint");
                WireMock.givenThat((MappingBuilder)RestEndPointMocker.createDeleteRequestBuilder(mockStep).willReturn(RestEndPointMocker.responseBuilder(mockStep, jsonBodyRequest)));
                LOGGER.debug("WireMock- Mocking the DELETE endpoint -done-*****");
            }
        });
    }

    public static void restartWireMock(int dynamicPort) {
        if (wireMockServer != null) {
            wireMockServer.stop();
        }
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().extensions(new Extension[]{new ResponseTemplateTransformer(true, RestEndPointMocker.getWiremockHelpers())}).port(dynamicPort));
        wireMockServer.start();
        WireMock.configureFor((String)"localhost", (int)dynamicPort);
    }

    private static Map<String, Helper> getWiremockHelpers() {
        HashedMap helperMap = new HashedMap();
        helperMap.put("localdatetime", new HandlebarsLocalDateHelper());
        return helperMap;
    }

    public static void stopWireMockServer() {
        if (null != wireMockServer) {
            wireMockServer.stop();
            wireMockServer = null;
            LOGGER.debug("Scenario: All mockings done via WireMock server. Dependant end points executed. Stopped WireMock.");
        }
    }

    private static MappingBuilder createDeleteRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.delete((UrlPattern)RestEndPointMocker.buildUrlPattern(mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createPatchRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.patch((UrlPattern)RestEndPointMocker.buildUrlPattern(mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createPutRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.put((UrlPattern)RestEndPointMocker.buildUrlPattern(mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createPostRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.post((UrlPattern)RestEndPointMocker.buildUrlPattern(mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static MappingBuilder createGetRequestBuilder(MockStep mockStep) {
        MappingBuilder requestBuilder = WireMock.get((UrlPattern)RestEndPointMocker.buildUrlPattern(mockStep.getUrl()));
        return RestEndPointMocker.createRequestBuilderWithHeaders(mockStep, requestBuilder);
    }

    private static UrlPattern buildUrlPattern(String url) {
        if (url != null && !url.contains("?") && !shouldBuildStrictUrlMatcherForAllUrls.booleanValue()) {
            LOGGER.debug("Going to build lenient matcher for url={}", (Object)url);
            return WireMock.urlPathEqualTo((String)url);
        }
        LOGGER.debug("Going to build strict matcher for url={}", (Object)url);
        return WireMock.urlEqualTo((String)url);
    }

    private static MappingBuilder createRequestBuilderWithHeaders(MockStep mockStep, MappingBuilder requestBuilder) {
        Map<String, Object> headersMap;
        String bodyJson = mockStep.getBody();
        if (StringUtils.isNotEmpty((CharSequence)bodyJson)) {
            requestBuilder.withRequestBody((ContentPattern)WireMock.equalToJson((String)bodyJson));
        }
        if ((headersMap = mockStep.getHeadersMap()).size() > 0) {
            for (String key : headersMap.keySet()) {
                requestBuilder.withHeader(key, WireMock.equalTo((String)((String)headersMap.get(key))));
            }
        }
        return requestBuilder;
    }

    private static ResponseDefinitionBuilder responseBuilder(MockStep mockStep, String jsonBodyRequest) {
        ResponseDefinitionBuilder responseBuilder = WireMock.aResponse().withStatus(mockStep.getResponse().get("status").asInt());
        JsonNode headers = mockStep.getResponse().get("headers");
        JsonNode contentType = headers != null ? headers.get("Content-Type") : null;
        responseBuilder = contentType != null ? responseBuilder.withHeader("Content-Type", new String[]{contentType.textValue()}).withBody(jsonBodyRequest) : responseBuilder.withBody(jsonBodyRequest);
        return responseBuilder;
    }

    public static int createWithLocalMock(String endPointJsonApi) {
        if (StringUtils.isNotEmpty((CharSequence)endPointJsonApi)) {
            // empty if block
        }
        return 200;
    }

    public static WireMockServer getWireMockServer() {
        return wireMockServer;
    }

    public static int createWithVirtuosoMock(String endPointJsonApi) {
        return 200;
    }

    static {
        shouldBuildStrictUrlMatcherForAllUrls = false;
    }
}

