/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.preprocessor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.univocity.parsers.csv.CsvParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jsmart.zerocode.core.constants.ZerocodeConstants;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeParameterizedProcessor;
import org.jsmart.zerocode.core.utils.TokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ZeroCodeParameterizedProcessorImpl
implements ZeroCodeParameterizedProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeParameterizedProcessorImpl.class);
    public static final String VALUE_SOURCE_KEY = "0";
    private final ObjectMapper objectMapper;
    private final CsvParser csvParser;

    @Inject
    public ZeroCodeParameterizedProcessorImpl(ObjectMapper objectMapper, CsvParser csvParser) {
        this.objectMapper = objectMapper;
        this.csvParser = csvParser;
    }

    @Override
    public ScenarioSpec resolveParameterized(ScenarioSpec scenario, int iteration) {
        if (scenario.getParameterized() == null) {
            return scenario;
        }
        if (scenario.getParameterized().getValueSource() != null) {
            return this.resolveParamsValues(scenario, iteration);
        }
        if (CollectionUtils.isNotEmpty(scenario.getParameterized().getCsvSource())) {
            return this.resolveParamsCsv(scenario, iteration);
        }
        throw new RuntimeException("Scenario spec was invalid. Please check the DSL format \ne.g. \n" + ZerocodeConstants.DSL_FORMAT);
    }

    private ScenarioSpec resolveParamsValues(ScenarioSpec scenario, int paramIndex) {
        LOGGER.debug("Resolving parameter value-source for index - {}", (Object)paramIndex);
        try {
            String stepJson = this.objectMapper.writeValueAsString((Object)scenario);
            List<Object> parameterized = scenario.getParameterized().getValueSource();
            if (parameterized == null || parameterized.isEmpty()) {
                return scenario;
            }
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put(VALUE_SOURCE_KEY, parameterized.get(paramIndex));
            String resultantStepJson = this.replaceWithValues(stepJson, valuesMap);
            return (ScenarioSpec)this.objectMapper.readValue(resultantStepJson, ScenarioSpec.class);
        }
        catch (Exception exx) {
            throw new RuntimeException("Error while resolving parameterized values for a scenario - " + exx);
        }
    }

    private ScenarioSpec resolveParamsCsv(ScenarioSpec scenario, int paramIndex) {
        LOGGER.debug("Resolving parameter CSV-source for row number - {}", (Object)paramIndex);
        try {
            String stepJson = this.objectMapper.writeValueAsString((Object)scenario);
            List<String> parameterizedCsvList = scenario.getParameterized().getCsvSource();
            if (parameterizedCsvList == null || parameterizedCsvList.isEmpty()) {
                return scenario;
            }
            String[] headers = this.retrieveCsvHeaders(parameterizedCsvList.get(0));
            paramIndex = headers == null ? paramIndex : paramIndex + 1;
            String csvLine = parameterizedCsvList.get(paramIndex);
            Map<String, Object> valuesMap = this.resolveCsvLine(csvLine, headers);
            String resultantStepJson = this.replaceWithValues(stepJson, valuesMap);
            return (ScenarioSpec)this.objectMapper.readValue(resultantStepJson, ScenarioSpec.class);
        }
        catch (Exception exx) {
            throw new RuntimeException("Error while resolving parameterizedCsv values - " + exx);
        }
    }

    private String[] retrieveCsvHeaders(String csvHeaderLine) {
        String[] parsedHeaderLine = this.csvParser.parseLine(csvHeaderLine + "\n");
        boolean hasHeader = parsedHeaderLine.length > 0 && Arrays.stream(parsedHeaderLine).allMatch(s -> s.matches("^\\|.*\\|$"));
        return !hasHeader ? null : (String[])Arrays.stream(parsedHeaderLine).map(s -> s.substring(1, s.length() - 1)).toArray(String[]::new);
    }

    private Map<String, Object> resolveCsvLine(String csvLine, String[] headers) {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        String[] parsedLine = this.csvParser.parseLine(csvLine + "\n");
        IntStream.range(0, parsedLine.length).forEach(i -> valuesMap.put(i + "", parsedLine[i]));
        if (headers != null) {
            IntStream.range(0, headers.length).forEach(i -> {
                if (!headers[i].contains(" ") && !headers[i].isEmpty()) {
                    valuesMap.put("PARAM." + headers[i], TokenUtils.resolveKnownTokens(parsedLine[i]).toString());
                }
            });
        }
        return valuesMap;
    }

    private String replaceWithValues(String stepJson, Map<String, Object> valuesMap) {
        StringSubstitutor sub = new StringSubstitutor(valuesMap);
        return sub.replace(stepJson);
    }
}

