/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.di.main.ApplicationMainModule;
import org.jsmart.zerocode.core.di.module.RuntimeHttpClientModule;
import org.jsmart.zerocode.core.di.module.RuntimeKafkaClientModule;
import org.jsmart.zerocode.core.domain.JsonTestCase;
import org.jsmart.zerocode.core.domain.JsonTestCases;
import org.jsmart.zerocode.core.domain.Scenario;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.Scenarios;
import org.jsmart.zerocode.core.domain.TargetEnv;
import org.jsmart.zerocode.core.domain.TestPackageRoot;
import org.jsmart.zerocode.core.domain.UseHttpClient;
import org.jsmart.zerocode.core.domain.UseKafkaClient;
import org.jsmart.zerocode.core.engine.listener.TestUtilityListener;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.httpclient.ssl.SslTrustHttpClient;
import org.jsmart.zerocode.core.kafka.client.BasicKafkaClient;
import org.jsmart.zerocode.core.kafka.client.ZerocodeCustomKafkaClient;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodePackageRunner
extends ParentRunner<ScenarioSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodePackageRunner.class);
    private final Class<?> testClass;
    private List<ScenarioSpec> scenarioSpecs;
    private Injector injector;
    private SmartUtils smartUtils;
    protected Description scenarioDescription;
    protected boolean isRunSuccess;
    protected boolean passed;
    protected boolean testRunCompleted;
    private ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner;

    public ZeroCodePackageRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.zeroCodeMultiStepsScenarioRunner = this.getInjectedMultiStepsRunner();
        this.smartUtils = this.getInjectedSmartUtilsClass();
    }

    protected SmartUtils getInjectedSmartUtilsClass() {
        return (SmartUtils)this.getMainModuleInjector().getInstance(SmartUtils.class);
    }

    @Inject
    public ZeroCodePackageRunner(Class<?> testClass, SmartUtils smartUtils) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.smartUtils = smartUtils;
    }

    protected List<ScenarioSpec> getChildren() {
        TestPackageRoot rootPackageAnnotation = this.testClass.getAnnotation(TestPackageRoot.class);
        JsonTestCases jsonTestCasesAnnotation = this.testClass.getAnnotation(JsonTestCases.class);
        Scenarios scenariosAnnotation = this.testClass.getAnnotation(Scenarios.class);
        this.validateSuiteAnnotationPresent(rootPackageAnnotation, jsonTestCasesAnnotation, scenariosAnnotation);
        if (rootPackageAnnotation != null) {
            this.smartUtils.checkDuplicateScenarios(rootPackageAnnotation.value());
            return this.smartUtils.getScenarioSpecListByPackage(rootPackageAnnotation.value());
        }
        List<String> allEndPointFiles = this.readTestScenarioFiles();
        return allEndPointFiles.stream().map(testResource -> {
            try {
                return this.smartUtils.scenarioFileToJava((String)testResource, ScenarioSpec.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while deserializing to Spec. Details: " + e);
            }
        }).collect(Collectors.toList());
    }

    protected Description describeChild(ScenarioSpec child) {
        this.scenarioDescription = Description.createTestDescription(this.testClass, (String)child.getScenarioName());
        return this.scenarioDescription;
    }

    public void run(RunNotifier notifier) {
        RunListener reportListener = this.createTestUtilityListener();
        notifier.addListener(reportListener);
        LOGGER.debug("System property zerocode.junit=" + System.getProperty("zerocode.junit"));
        if (!"gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            notifier.addListener(reportListener);
        }
        super.run(notifier);
        this.handleNoRunListenerReport(reportListener);
    }

    protected RunListener createTestUtilityListener() {
        return (RunListener)this.getMainModuleInjector().getInstance(TestUtilityListener.class);
    }

    protected void runChild(ScenarioSpec child, RunNotifier notifier) {
        Description description = Description.createTestDescription(this.testClass, (String)child.getScenarioName());
        notifier.fireTestStarted(description);
        this.passed = this.zeroCodeMultiStepsScenarioRunner.runScenario(child, notifier, description);
        this.testRunCompleted = true;
        if (this.passed) {
            LOGGER.debug(String.format("\nPackageRunner- **FINISHED executing all Steps for [%s] **.\nSteps were:%s", child.getScenarioName(), child.getSteps().stream().map(step -> step.getName()).collect(Collectors.toList())));
        }
        notifier.fireTestFinished(description);
    }

    public Injector getMainModuleInjector() {
        TargetEnv envAnnotation = this.testClass.getAnnotation(TargetEnv.class);
        String serverEnv = envAnnotation != null ? envAnnotation.value() : "config_hosts.properties";
        serverEnv = RunnerUtils.getEnvSpecificConfigFile(serverEnv, this.testClass);
        Class<? extends BasicHttpClient> runtimeHttpClient = this.createCustomHttpClientOrDefault();
        Class<? extends BasicKafkaClient> runtimeKafkaClient = this.createCustomKafkaClientOrDefault();
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ApplicationMainModule(serverEnv)}).with(new Module[]{new RuntimeHttpClientModule(runtimeHttpClient), new RuntimeKafkaClientModule(runtimeKafkaClient)})});
    }

    public void setSmartUtils(SmartUtils smartUtils) {
        this.smartUtils = smartUtils;
    }

    public boolean isRunSuccess() {
        return this.isRunSuccess;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public boolean isTestRunCompleted() {
        return this.testRunCompleted;
    }

    public void setZeroCodeMultiStepsScenarioRunner(ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner) {
        this.zeroCodeMultiStepsScenarioRunner = zeroCodeMultiStepsScenarioRunner;
    }

    public Class<? extends BasicKafkaClient> createCustomKafkaClientOrDefault() {
        UseKafkaClient kafkaClientAnnotated = this.getUseKafkaClient();
        return kafkaClientAnnotated != null ? kafkaClientAnnotated.value() : ZerocodeCustomKafkaClient.class;
    }

    public Class<? extends BasicHttpClient> createCustomHttpClientOrDefault() {
        UseHttpClient httpClientAnnotated = this.getUseHttpClient();
        return httpClientAnnotated != null ? httpClientAnnotated.value() : SslTrustHttpClient.class;
    }

    public UseHttpClient getUseHttpClient() {
        return this.testClass.getAnnotation(UseHttpClient.class);
    }

    public UseKafkaClient getUseKafkaClient() {
        return this.testClass.getAnnotation(UseKafkaClient.class);
    }

    private ZeroCodeMultiStepsScenarioRunner getInjectedMultiStepsRunner() {
        this.zeroCodeMultiStepsScenarioRunner = (ZeroCodeMultiStepsScenarioRunner)this.getMainModuleInjector().getInstance(ZeroCodeMultiStepsScenarioRunner.class);
        return this.zeroCodeMultiStepsScenarioRunner;
    }

    private ZeroCodeReportGenerator getInjectedReportGenerator() {
        return (ZeroCodeReportGenerator)this.getMainModuleInjector().getInstance(ZeroCodeReportGenerator.class);
    }

    private void handleNoRunListenerReport(RunListener reportListener) {
        RunnerUtils.handleTestCompleted(reportListener, LOGGER);
    }

    private List<String> readTestScenarioFiles() {
        List<Annotation> jsonTestCases = Arrays.asList(this.testClass.getAnnotationsByType(JsonTestCase.class));
        if (jsonTestCases != null && jsonTestCases.size() > 0) {
            return jsonTestCases.stream().map(thisTestCase -> thisTestCase.value()).collect(Collectors.toList());
        }
        List<Annotation> scenarios = Arrays.asList(this.testClass.getAnnotationsByType(Scenario.class));
        return scenarios.stream().map(thisTestCase -> thisTestCase.value()).collect(Collectors.toList());
    }

    private void validateSuiteAnnotationPresent(TestPackageRoot rootPackageAnnotation, JsonTestCases jsonTestCasesAnnotation, Scenarios scenarios) {
        if (rootPackageAnnotation == null && jsonTestCasesAnnotation == null && scenarios == null) {
            throw new RuntimeException("Missing Test Suite details.To run as a Test Suite - \nAnnotate your Test Suite class with, e.g. \n@TestPackageRoot(\"resource_folder_for_scenario_files\") \n\n-Or- \nAnnotate your Test Suite class with, e.g. \n@JsonTestCases({\n        @JsonTestCase(\"path/to/test_case_1.json\"),\n        @JsonTestCase(\"path/to/test_case_2.json\")\n})\n\n-Or- \nAnnotate your Test Suite class with, e.g. \n@Scenarios({\n        @Scenario(\"path/to/test_case_1.json\"),\n        @Scenario(\"path/to/test_case_2.json\")\n})\n\n-Or- \nRun as usual 'Junit Suite' pointing to the individual test classes.");
        }
    }
}

