/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner.parallel;

import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsmart.zerocode.parallel.ExecutorServiceRunner;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadProcessor.class);
    private final String loadPropertiesFile;
    private final AtomicInteger passedCounter = new AtomicInteger();
    private final AtomicInteger failedCounter = new AtomicInteger();
    private ExecutorServiceRunner executorServiceRunner;
    private boolean failed = true;
    private boolean passed = !this.failed;

    public LoadProcessor(String loadPropertiesFile) {
        this.loadPropertiesFile = loadPropertiesFile;
        this.executorServiceRunner = this.createExecutorServiceRunner();
    }

    public ExecutorServiceRunner getExecutorServiceRunner() {
        return this.executorServiceRunner;
    }

    public AtomicInteger getPassedCounter() {
        return this.passedCounter;
    }

    public AtomicInteger getFailedCounter() {
        return this.failedCounter;
    }

    public String getLoadPropertiesFile() {
        return this.loadPropertiesFile;
    }

    public ExecutorServiceRunner createExecutorServiceRunner() {
        return new ExecutorServiceRunner(this.getLoadPropertiesFile());
    }

    public LoadProcessor addTest(Class<?> testClass, String testMethod) {
        Runnable zeroCodeJunitTest = this.createRunnable(testClass, testMethod);
        this.executorServiceRunner.addRunnable(zeroCodeJunitTest);
        return this;
    }

    public boolean process() {
        this.executorServiceRunner.runRunnables();
        LOGGER.debug("\n------------------------------------\n   >> Total load test count:" + (this.failedCounter.get() + this.passedCounter.get()) + "\n   >> Passed count:" + this.passedCounter.get() + "\n   >> Failed count:" + this.failedCounter.get() + "\n------------------------------------");
        LOGGER.warn("\n-----------------------------------------------------------------------------------------------------------\n==>> Completed this load-run!\n==>> Number of load tests ran : " + (this.failedCounter.get() + this.passedCounter.get()) + "\n==>> View the detailed performance results in the 'target/" + "zerocode-junit-granular-report.csv" + "' folder.\n-----------------------------------------------------------------------------------------------------------\n\n");
        if (this.failedCounter.get() > 0) {
            return this.failed;
        }
        return this.passed;
    }

    public boolean processMultiLoad() {
        this.executorServiceRunner.runRunnablesMulti();
        LOGGER.debug("\n------------------------------------\n   >> Total load test count:" + (this.failedCounter.get() + this.passedCounter.get()) + "\n   >> Passed count:" + this.passedCounter.get() + "\n   >> Failed count:" + this.failedCounter.get() + "\n------------------------------------");
        LOGGER.warn("\n-----------------------------------------------------------------------------------------------------------\n==>> Completed this load-run!\n==>> Number of load tests ran : " + (this.failedCounter.get() + this.passedCounter.get()) + "\n==>> View the detailed performance results in the 'target/" + "zerocode-junit-granular-report.csv" + "' folder.\n-----------------------------------------------------------------------------------------------------------\n\n");
        if (this.failedCounter.get() > 0) {
            return this.failed;
        }
        return this.passed;
    }

    private Runnable createRunnable(Class<?> testClass, String testMathod) {
        return () -> {
            LOGGER.debug(Thread.currentThread().getName() + " Parallel Junit test- *Start. Time = " + LocalDateTime.now());
            Result result = new JUnitCore().run(Request.method((Class)testClass, (String)testMathod));
            LOGGER.debug(Thread.currentThread().getName() + " Parallel Junit test- *  End. Time = " + LocalDateTime.now());
            if (result.wasSuccessful()) {
                this.passedCounter.incrementAndGet();
            } else {
                this.failedCounter.incrementAndGet();
            }
        };
    }
}

