/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.db;

import com.univocity.parsers.csv.CsvParser;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.jsmart.zerocode.core.db.DbValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DbCsvLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCsvLoader.class);
    private Connection conn;
    private CsvParser csvParser;

    public DbCsvLoader(Connection conn, CsvParser csvParser) {
        this.conn = conn;
        this.csvParser = csvParser;
    }

    public int loadCsv(String table, List<String> csvLines, boolean withHeaders, String nullString) throws SQLException {
        if (csvLines == null || csvLines.isEmpty()) {
            return 0;
        }
        List<String[]> lines = this.parseLines(table, csvLines);
        String[] headers = this.buildHeaders(lines.get(0), withHeaders);
        List<Object[]> paramset = this.buildParameters(table, headers, lines, withHeaders, nullString);
        if (paramset.isEmpty()) {
            return 0;
        }
        String sql = this.buildSql(table, headers, paramset.get(0).length);
        LOGGER.info("Loading CSV using this sql: {}", (Object)sql);
        QueryRunner runner = new QueryRunner();
        int insertCount = 0;
        for (int i = 0; i < paramset.size(); ++i) {
            this.insertRow(runner, i, sql, paramset.get(i));
            ++insertCount;
        }
        LOGGER.info("Total of rows inserted: {}", (Object)insertCount);
        return insertCount;
    }

    private List<String[]> parseLines(String table, List<String> lines) {
        int numCol = 0;
        ArrayList<String[]> parsedLines = new ArrayList<String[]>();
        for (int i = 0; i < lines.size(); ++i) {
            String[] parsedLine = this.csvParser.parseLine(lines.get(i));
            parsedLines.add(parsedLine);
            if (i == 0) {
                numCol = parsedLine.length;
                continue;
            }
            if (numCol == parsedLine.length) continue;
            String message = String.format("Error parsing CSV content to load into table %s: Row %d has %d columns and should have %d", table, i + 1, parsedLine.length, numCol);
            LOGGER.error(message);
            throw new RuntimeException(message);
        }
        return parsedLines;
    }

    private String[] buildHeaders(String[] line, boolean withHeaders) {
        return withHeaders ? line : new String[]{};
    }

    private List<Object[]> buildParameters(String table, String[] headers, List<String[]> lines, boolean withHeaders, String nullString) {
        int i;
        DbValueConverter converter = new DbValueConverter(this.conn, table);
        ArrayList<Object[]> paramset = new ArrayList<Object[]>();
        int n = i = withHeaders ? 1 : 0;
        while (i < lines.size()) {
            Object[] params;
            String[] parsedLine = lines.get(i);
            parsedLine = this.processNulls(parsedLine, nullString);
            try {
                params = converter.convertColumnValues(headers, parsedLine);
                LOGGER.info("    row [{}] params: {}", (Object)(i + 1), (Object)Arrays.asList(params).toString());
            }
            catch (Exception e) {
                String message = String.format("Error matching data type of parameters and table columns at CSV row %d", i + 1);
                LOGGER.error(message);
                LOGGER.error("Exception message: {}", (Object)e.getMessage());
                throw new RuntimeException(message, e);
            }
            paramset.add(params);
            ++i;
        }
        return paramset;
    }

    private String[] processNulls(String[] line, String nullString) {
        for (int i = 0; i < line.length; ++i) {
            if (StringUtils.isBlank((CharSequence)nullString) && StringUtils.isBlank((CharSequence)line[i])) {
                line[i] = null;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)nullString)) continue;
            if (StringUtils.isBlank((CharSequence)line[i])) {
                line[i] = "";
                continue;
            }
            if (!nullString.trim().equalsIgnoreCase(line[i].trim())) continue;
            line[i] = null;
        }
        return line;
    }

    private String buildSql(String table, String[] headers, int columnCount) {
        String placeholders = IntStream.range(0, columnCount).mapToObj(i -> "?").collect(Collectors.joining(","));
        return "INSERT INTO " + table + (headers.length > 0 ? " (" + String.join((CharSequence)",", headers) + ")" : "") + " VALUES (" + placeholders + ");";
    }

    private void insertRow(QueryRunner runner, int rowId, String sql, Object[] params) {
        try {
            runner.update(this.conn, sql, params);
        }
        catch (SQLException e) {
            String message = String.format("Error inserting data at CSV row %d", rowId + 1);
            LOGGER.error(message);
            LOGGER.error("Exception message: {}", (Object)e.getMessage());
            throw new RuntimeException(message, e);
        }
    }
}

