/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.univocity.parsers.csv.CsvParser;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.jsmart.zerocode.core.db.DbCsvLoader;
import org.jsmart.zerocode.core.db.DbCsvRequest;
import org.jsmart.zerocode.core.db.DbSqlRequest;
import org.jsmart.zerocode.core.db.DbSqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSqlExecutor.class);
    public static final String SQL_RESULTS_KEY = "rows";
    public static final String CSV_RESULTS_KEY = "size";
    @Inject(optional=true)
    @Named(value="db.driver.url")
    private String url;
    @Inject(optional=true)
    @Named(value="db.driver.user")
    private String user;
    @Inject(optional=true)
    @Named(value="db.driver.password")
    private String password;
    @Inject
    private CsvParser csvParser;

    public Map<String, Object> LOADCSV(DbCsvRequest request) {
        return this.loadcsv(request);
    }

    public Map<String, Object> loadcsv(DbCsvRequest request) {
        Connection conn = this.createAndGetConnection();
        try {
            LOGGER.info("Load CSV, request -> {} ", (Object)request);
            DbCsvLoader runner = new DbCsvLoader(conn, this.csvParser);
            long result = runner.loadCsv(request.getTableName(), request.getCsvSource(), request.getWithHeaders(), request.getNullString());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(CSV_RESULTS_KEY, result);
            HashMap<String, Object> hashMap = response;
            return hashMap;
        }
        catch (Exception e) {
            String message = "Failed to load CSV";
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Map<String, Object> EXECUTE(DbSqlRequest request) {
        return this.execute(request);
    }

    public Map<String, Object> execute(DbSqlRequest request) {
        Connection conn = this.createAndGetConnection();
        try {
            LOGGER.info("Execute SQL, request -> {} ", (Object)request);
            DbSqlRunner runner = new DbSqlRunner(conn);
            List<Map<String, Object>> results = runner.execute(request.getSql(), request.getSqlParams());
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (results == null) {
                response.put(SQL_RESULTS_KEY, new ObjectMapper().createObjectNode());
            } else {
                response.put(SQL_RESULTS_KEY, results);
            }
            HashMap<String, Object> hashMap = response;
            return hashMap;
        }
        catch (SQLException e) {
            String message = "Failed to execute SQL";
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    protected Connection createAndGetConnection() {
        LOGGER.info("Create and get connection, url: {}, user: {}", (Object)this.url, (Object)this.user);
        try {
            return DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            String message = "Failed to create connection, Please check the target environment properties to connect the database (db.driver.url, db.driver.user and db.driver.password)";
            LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    protected void closeConnection(Connection conn) {
        DbUtils.closeQuietly((Connection)conn);
    }
}

