/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jsmart.zerocode.core.db.DbSqlExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSqlExecutor.class);
    private Connection conn;
    private String table;
    private DatabaseMetaData databaseMetaData;
    public Map<String, Integer> columnTypes;

    public DbValueConverter(Connection conn, String table) {
        this.conn = conn;
        this.table = table;
        try {
            this.initializeMetadata();
        }
        catch (Exception e) {
            this.logInitializeError();
        }
    }

    private void initializeMetadata() throws SQLException {
        LOGGER.info("Metadata initialization for table: {}", (Object)this.table);
        this.columnTypes = new LinkedHashMap<String, Integer>();
        this.databaseMetaData = this.conn.getMetaData();
        this.table = this.convertToStoredCase(this.table);
        LOGGER.info("Database storesLowerCaseIdentifiers={}, storesUpperCaseIdentifiers={}", (Object)this.databaseMetaData.storesLowerCaseIdentifiers(), (Object)this.databaseMetaData.storesUpperCaseIdentifiers());
        try (ResultSet rs = this.databaseMetaData.getColumns(null, null, this.table, "%");){
            while (rs.next()) {
                String storedName = rs.getString("COLUMN_NAME");
                int typeValue = rs.getInt("DATA_TYPE");
                this.columnTypes.put(storedName.toLowerCase(), typeValue);
            }
        }
        LOGGER.info("Mapping from java columns to sql types: {}", (Object)this.columnTypes.toString());
        if (this.columnTypes.isEmpty()) {
            this.logInitializeError();
        }
    }

    private String convertToStoredCase(String identifier) throws SQLException {
        if (this.databaseMetaData.storesLowerCaseIdentifiers()) {
            identifier = identifier.toLowerCase();
        } else if (this.databaseMetaData.storesUpperCaseIdentifiers()) {
            identifier = identifier.toUpperCase();
        }
        return identifier;
    }

    private void logInitializeError() {
        LOGGER.error("Initialization of metadata for table {} failed. Errors may appear when matching query parameters to their data types", (Object)this.table);
    }

    Object[] convertColumnValues(String[] columns, String[] values) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            columns = this.columnTypes.keySet().toArray(new String[0]);
        }
        Object[] converted = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = i < columns.length && i < values.length ? this.convertColumnValue(columns[i], values[i]) : values[i];
        }
        return converted;
    }

    private Object convertColumnValue(String column, String value) {
        try {
            return this.convertColumnValueWithThrow(column, value);
        }
        catch (ParseException e) {
            LOGGER.error("Can't convert the data type of value {} at column {}", (Object)value, (Object)column);
            return value;
        }
    }

    private Object convertColumnValueWithThrow(String column, String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if (!this.columnTypes.containsKey(column.toLowerCase())) {
            return value;
        }
        int sqlType = this.columnTypes.get(column.toLowerCase());
        return this.convertColumnValueFromJavaSqlType(sqlType, value);
    }

    private Object convertColumnValueFromJavaSqlType(int sqlType, String value) throws ParseException {
        switch (sqlType) {
            case 2: 
            case 3: {
                return BigDecimal.valueOf(Double.parseDouble(value));
            }
            case -7: 
            case 16: {
                return Boolean.valueOf("1".equals(value) ? "true" : value);
            }
            case -6: {
                return Byte.valueOf(value);
            }
            case 5: {
                return Short.valueOf(value);
            }
            case 4: {
                return Integer.valueOf(value);
            }
            case -5: {
                return Long.valueOf(value);
            }
            case 7: {
                return Float.valueOf(value);
            }
            case 6: {
                return Double.valueOf(value);
            }
            case 8: {
                return Double.valueOf(value);
            }
            case 91: {
                return new Date(DateUtils.parseDate((String)value, (String[])this.getDateFormats()).getTime());
            }
            case 92: {
                return new Time(DateUtils.parseDate((String)value, (String[])this.getTimeFormats()).getTime());
            }
            case 93: {
                return new Timestamp(DateUtils.parseDate((String)value, (String[])this.getTimestampFormats()).getTime());
            }
        }
        return value;
    }

    private String[] getDateFormats() {
        return new String[]{"yyyy-MM-dd"};
    }

    private String[] getTimeFormats() {
        return new String[]{"HH:mm:ssZ", "HH:mm:ss.SSSZ", "HH:mm:ss", "HH:mm:ss.SSS"};
    }

    private String[] getTimestampFormats() {
        return new String[]{"yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS"};
    }
}

