/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.di.main;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Properties;
import java.util.logging.Logger;
import org.jsmart.zerocode.core.di.module.CsvParserModule;
import org.jsmart.zerocode.core.di.module.GsonModule;
import org.jsmart.zerocode.core.di.module.HttpClientModule;
import org.jsmart.zerocode.core.di.module.ObjectMapperModule;
import org.jsmart.zerocode.core.di.module.PropertiesInjectorModule;
import org.jsmart.zerocode.core.engine.executor.ApiServiceExecutor;
import org.jsmart.zerocode.core.engine.executor.ApiServiceExecutorImpl;
import org.jsmart.zerocode.core.engine.executor.httpapi.HttpApiExecutor;
import org.jsmart.zerocode.core.engine.executor.httpapi.HttpApiExecutorImpl;
import org.jsmart.zerocode.core.engine.executor.javaapi.JavaMethodExecutor;
import org.jsmart.zerocode.core.engine.executor.javaapi.JavaMethodExecutorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeAssertionsProcessorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeExternalFileProcessorImpl;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeParameterizedProcessor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeParameterizedProcessorImpl;
import org.jsmart.zerocode.core.engine.sorter.ZeroCodeSorter;
import org.jsmart.zerocode.core.engine.sorter.ZeroCodeSorterImpl;
import org.jsmart.zerocode.core.engine.validators.ZeroCodeValidator;
import org.jsmart.zerocode.core.engine.validators.ZeroCodeValidatorImpl;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.report.ZeroCodeReportGeneratorImpl;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;
import org.jsmart.zerocode.core.utils.PropertiesProviderUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;

public class ApplicationMainModule
extends AbstractModule {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMainModule.class.getName());
    private final String serverEnv;

    public ApplicationMainModule(String serverEnv) {
        this.serverEnv = serverEnv;
    }

    public void configure() {
        this.install(new ObjectMapperModule());
        this.install(new HttpClientModule());
        this.install(new GsonModule());
        this.install((Module)new PropertiesInjectorModule(this.serverEnv));
        this.install(new CsvParserModule());
        this.bind(ZeroCodeMultiStepsScenarioRunner.class).to(ZeroCodeMultiStepsScenarioRunnerImpl.class);
        this.bind(ApiServiceExecutor.class).to(ApiServiceExecutorImpl.class);
        this.bind(HttpApiExecutor.class).to(HttpApiExecutorImpl.class);
        this.bind(JavaMethodExecutor.class).to(JavaMethodExecutorImpl.class);
        this.bind(ZeroCodeAssertionsProcessor.class).to(ZeroCodeAssertionsProcessorImpl.class);
        this.bind(ZeroCodeValidator.class).to(ZeroCodeValidatorImpl.class);
        this.bind(ZeroCodeReportGenerator.class).to(ZeroCodeReportGeneratorImpl.class);
        this.bind(ZeroCodeExternalFileProcessor.class).to(ZeroCodeExternalFileProcessorImpl.class);
        this.bind(ZeroCodeParameterizedProcessor.class).to(ZeroCodeParameterizedProcessorImpl.class);
        this.bind(ZeroCodeSorter.class).to(ZeroCodeSorterImpl.class);
        Names.bindProperties((Binder)this.binder(), (Properties)this.getProperties(this.serverEnv));
    }

    public Properties getProperties(String host) {
        Properties properties = new Properties();
        if (SmartUtils.isValidAbsolutePath(host)) {
            return PropertiesProviderUtils.loadAbsoluteProperties(host, properties);
        }
        try {
            properties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(host));
            PropertiesProviderUtils.checkAndLoadOldProperties(properties);
        }
        catch (Exception e) {
            LOGGER.warning("###Oops!Exception### while reading target env file: " + host + ". Have you mentioned env details?");
            throw new RuntimeException("could not read the target-env properties file --" + host + "-- from the classpath.");
        }
        return properties;
    }
}

