/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MockStep {
    private final String name;
    private final String operation;
    private final String url;
    private final JsonNode request;
    private final JsonNode response;
    private final JsonNode assertions;
    private String body;
    private String headers;
    private Map<String, Object> headersMap;

    public String getName() {
        return this.name;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getUrl() {
        return this.url;
    }

    public JsonNode getRequest() {
        return Optional.ofNullable(this.request).orElse((JsonNode)NullNode.getInstance());
    }

    public JsonNode getResponse() {
        return Optional.ofNullable(this.response).orElse((JsonNode)NullNode.getInstance());
    }

    public JsonNode getAssertions() {
        return Optional.ofNullable(this.assertions).orElse((JsonNode)NullNode.getInstance());
    }

    public String getBody() {
        JsonNode bodyNode = this.getRequest().get("body");
        return bodyNode != null ? this.getRequest().get("body").toString() : null;
    }

    public String getHeaders() {
        return this.getRequest().get("headers").toString();
    }

    public Map<String, Object> getHeadersMap() {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        HashMap headersMap = new HashMap();
        try {
            JsonNode headersNode = this.getRequest().get("headers");
            if (null != headersNode) {
                headersMap = (HashMap)objectMapper.readValue(headersNode.toString(), HashMap.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return headersMap;
    }

    @JsonCreator
    public MockStep(@JsonProperty(value="name") String name, @JsonProperty(value="operation") String operation, @JsonProperty(value="url") String url, @JsonProperty(value="request") JsonNode request, @JsonProperty(value="response") JsonNode response, @JsonProperty(value="assertions") JsonNode assertions) {
        this.name = name;
        this.operation = operation;
        this.request = request;
        this.url = url;
        this.response = response;
        this.assertions = assertions;
    }

    public String toString() {
        return "Step{, name='" + this.name + '\'' + ", operation='" + this.operation + '\'' + ", url='" + this.url + '\'' + ", request=" + this.request + ", response=" + this.response + ", assertions=" + this.assertions + '}';
    }
}

