/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.executor.javaapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsmart.zerocode.core.engine.executor.javaapi.JavaMethodExecutor;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMethodExecutorImpl
implements JavaMethodExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaMethodExecutorImpl.class);
    private final Injector injector;
    private final ObjectMapper objectMapper;

    @Inject
    public JavaMethodExecutorImpl(Injector injector, ObjectMapper objectMapper) {
        this.injector = injector;
        this.objectMapper = objectMapper;
    }

    @Override
    public String execute(String qualifiedClassName, String methodName, String requestJson) {
        try {
            Object result;
            List<Class<?>> parameterTypes = this.getParameterTypes(qualifiedClassName, methodName);
            if (parameterTypes == null || parameterTypes.isEmpty()) {
                result = this.executeWithParams(qualifiedClassName, methodName, new Object[0]);
            } else if (parameterTypes.size() == 1) {
                Object request = this.objectMapper.readValue(requestJson, parameterTypes.get(0));
                result = this.executeWithParams(qualifiedClassName, methodName, request);
            } else {
                Object[] requestArgs = this.getRequestArgs(parameterTypes, requestJson);
                result = this.executeWithParams(qualifiedClassName, methodName, requestArgs);
            }
            String resultJson = this.objectMapper.writeValueAsString(result);
            return SmartUtils.prettyPrintJson(resultJson);
        }
        catch (Exception e) {
            LOGGER.error("Exception - " + e);
            throw new RuntimeException(e);
        }
    }

    private Object[] getRequestArgs(List<Class<?>> parameterTypes, String requestJson) {
        ArrayList<Object> args = new ArrayList<Object>();
        JsonNode root = null;
        try {
            root = this.objectMapper.readTree(requestJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not parse Java method request Json ", e);
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            try {
                args.add(this.objectMapper.treeToValue((TreeNode)root.get(String.valueOf(i)), parameterTypes.get(i)));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Could not convert value " + i + " to type " + parameterTypes.get(i), e);
            }
        }
        return args.toArray();
    }

    Object executeWithParams(String qualifiedClassName, String methodName, Object ... params) {
        try {
            Method method = this.findMatchingMethod(qualifiedClassName, methodName);
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, params);
            }
            Object objectToInvokeOn = this.injector.getInstance(Class.forName(qualifiedClassName));
            return method.invoke(objectToInvokeOn, params);
        }
        catch (Exception e) {
            String errMsg = String.format("Java exec(): Invocation failed for method %s in class %s", methodName, qualifiedClassName);
            LOGGER.error(errMsg + ". Exception - " + e);
            throw new RuntimeException(errMsg, e);
        }
    }

    Method findMatchingMethod(String className, String methodName) {
        try {
            Method[] allMethods;
            Class<?> clazz = Class.forName(className);
            for (Method m : allMethods = clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
            throw new RuntimeException(String.format("Java exec(): No matching method %s found in class %s", methodName, className));
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while finding the matching method - " + e);
            throw new RuntimeException(e);
        }
    }

    List<Class<?>> getParameterTypes(String className, String methodName) {
        return Arrays.asList(this.findMatchingMethod(className, methodName).getParameterTypes());
    }
}

