/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.utils;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlQueryParamsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlQueryParamsUtils.class);

    public static String setQueryParams(String httpUrl, Map<String, Object> queryParams) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(httpUrl);
        Map nullSafeQueryParams = Optional.ofNullable(queryParams).orElseGet(HashMap::new);
        nullSafeQueryParams.keySet().forEach(key -> uriBuilder.addParameter(key, nullSafeQueryParams.get(key).toString()));
        String composedURL = uriBuilder.build().toString();
        LOGGER.debug("### Effective url is : {}", (Object)composedURL);
        return composedURL;
    }
}

