/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextUtil {
    private static final Logger m_log = LoggerFactory.getLogger(TextUtil.class);
    static Map<String, String> keyWordMap_ = TextUtil.makeKeyWordMap();
    static final String KEYWORD_PREFIX = "_";

    public static String makeCodeId(String id) {
        return TextUtil.makeCodeId(id, false);
    }

    public static String makeCodeId(String id, boolean isTypeName) {
        if (id == null || id.length() == 0) {
            id = KEYWORD_PREFIX;
        } else {
            StringBuilder buf = null;
            for (int i = 0; i < id.length(); ++i) {
                if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                if (buf == null) {
                    buf = new StringBuilder(id);
                }
                buf.setCharAt(i, '_');
            }
            if (buf != null) {
                if (isTypeName && Character.isLowerCase(buf.charAt(0))) {
                    buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
                }
                id = buf.toString();
            } else if (isTypeName && Character.isLowerCase(id.charAt(0))) {
                id = Character.toUpperCase(id.charAt(0)) + id.substring(1);
            }
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                id = KEYWORD_PREFIX + id;
            }
        }
        String o = keyWordMap_.get(id);
        if (o != null) {
            id = o;
        }
        return id;
    }

    public static String makeTypeName(String str) {
        return TextUtil.ucFirst(TextUtil.makeCodeId(str, true));
    }

    private static void addKeyWord(Map<String, String> m, String kw) {
        m.put(kw, KEYWORD_PREFIX + kw);
    }

    private static Map<String, String> makeKeyWordMap() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            String resourceName = "/org/jsmiparser/util/JavaKeywords.txt";
            BufferedReader r = new BufferedReader(new InputStreamReader(TextUtil.class.getResourceAsStream(resourceName)));
            String keyword = r.readLine();
            while (keyword != null) {
                TextUtil.addKeyWord(m, keyword);
                keyword = r.readLine();
            }
            r.close();
            return m;
        }
        catch (Throwable e) {
            m_log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static String ucFirst(String str) {
        String result = str;
        if (str.length() > 0 && Character.isLowerCase(str.charAt(0))) {
            StringBuilder b = new StringBuilder(str);
            b.setCharAt(0, Character.toUpperCase(str.charAt(0)));
            result = b.toString();
        }
        return result;
    }

    public static String lcFirst(String str) {
        String result = str;
        if (str.length() > 0 && Character.isUpperCase(str.charAt(0))) {
            StringBuilder b = new StringBuilder(str);
            b.setCharAt(0, Character.toLowerCase(str.charAt(0)));
            result = b.toString();
        }
        return result;
    }

    public static String getPath(Package pkg) {
        m_log.debug("package: " + pkg);
        m_log.debug("getPath() for: " + pkg.getName());
        return "/" + pkg.getName().replace('.', '/');
    }

    public static String deleteChar(String str, char c) {
        if (str.indexOf(c) < 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == c) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }
}

