/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.multimap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenMultiMap<K, V>
implements Serializable {
    static final long serialVersionUID = 1L;
    protected MultiMap m_impl;

    public static <K, V> GenMultiMap<K, V> hashMap() {
        return new GenMultiMap<K, V>((MultiMap)MultiValueMap.decorate(new HashMap(), ArrayList.class));
    }

    public static <K, V> GenMultiMap<K, V> treeMap() {
        return new GenMultiMap<K, V>((MultiMap)MultiValueMap.decorate(new TreeMap(), ArrayList.class));
    }

    public GenMultiMap(MultiMap impl) {
        this.m_impl = impl;
    }

    public int size() {
        return this.m_impl.values().size();
    }

    public boolean isEmpty() {
        return this.m_impl.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.m_impl.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.m_impl.containsValue(value);
    }

    public List<V> getAll(K key) {
        List result = (List)this.m_impl.get(key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public V getOne(K key) throws IllegalArgumentException {
        List all = (List)this.m_impl.get(key);
        if (all == null) {
            return null;
        }
        if (all.size() > 1) {
            throw new IllegalArgumentException("More than one element was found for key: " + key);
        }
        return (V)all.get(0);
    }

    public List<V> put(K key, Collection<V> value) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (V v : value) {
            Object insertedObject = this.m_impl.put(key, v);
            if (insertedObject == null) continue;
            result.add(insertedObject);
        }
        return result;
    }

    public V put(K key, V value) {
        return (V)this.m_impl.put(key, value);
    }

    public Collection<V> remove(K key) {
        return (Collection)this.m_impl.remove(key);
    }

    public void putAllMultiMap(Map<? extends K, ? extends Collection<V>> t) {
        this.m_impl.putAll(t);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.m_impl.clear();
    }

    public Set<K> keySet() {
        return this.m_impl.keySet();
    }

    public Collection<V> values() {
        return this.m_impl.values();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m_impl.entrySet();
    }
}

