/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.problem;

import org.jsmiparser.util.problem.ProblemEvent;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.annotations.ProblemSeverity;

public abstract class AbstractProblemEventHandler
implements ProblemEventHandler {
    private int[] m_severityCounters = new int[ProblemSeverity.values().length];
    private int m_totalCounter;

    public void handle(ProblemEvent event) {
        int n = event.getSeverity().ordinal();
        this.m_severityCounters[n] = this.m_severityCounters[n] + 1;
        ++this.m_totalCounter;
    }

    public boolean isOk() {
        for (int i = 0; i < this.m_severityCounters.length; ++i) {
            int severityCounter;
            if (i < ProblemSeverity.ERROR.ordinal() || (severityCounter = this.m_severityCounters[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNotOk() {
        return !this.isOk();
    }

    public int getSeverityCount(ProblemSeverity severity) {
        return this.m_severityCounters[severity.ordinal()];
    }

    public int getTotalCount() {
        return this.m_totalCounter;
    }
}

