/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.problem;

import java.util.Arrays;
import java.util.Formatter;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.annotations.ProblemSeverity;

public class ProblemEvent {
    private Location m_location;
    private ProblemSeverity m_severity;
    private String m_messageKey;
    private String m_defaultMessage;
    private Object[] m_arguments;

    public ProblemEvent(Location location, ProblemSeverity severity, String messageKey, String defaultMessage, Object[] arguments) {
        this.m_location = location;
        this.m_severity = severity;
        this.m_messageKey = messageKey;
        this.m_defaultMessage = defaultMessage;
        this.m_arguments = arguments;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public ProblemSeverity getSeverity() {
        return this.m_severity;
    }

    public String getMessageKey() {
        return this.m_messageKey;
    }

    public Object[] getArguments() {
        return this.m_arguments;
    }

    public String getLocalizedMessage() {
        Formatter f = new Formatter();
        f.format(this.m_defaultMessage, this.m_arguments);
        return f.toString();
    }

    public String toString() {
        return "ProblemEvent{m_location=" + this.m_location + ", m_severity=" + (Object)((Object)this.m_severity) + ", m_messageKey='" + this.m_messageKey + '\'' + ", m_defaultMessage='" + this.m_defaultMessage + '\'' + ", m_arguments=" + (this.m_arguments == null ? null : Arrays.asList(this.m_arguments)) + '}';
    }
}

