/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.problem;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.jsmiparser.util.TextUtil;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.ProblemEvent;
import org.jsmiparser.util.problem.ProblemEventHandler;
import org.jsmiparser.util.problem.annotations.ProblemMethod;
import org.jsmiparser.util.problem.annotations.ProblemProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemInvocationHandler<T>
implements InvocationHandler {
    private ProblemEventHandler m_problemEventHandler;
    private Map<Method, MethodInvocationHandler> m_methodInvocationHandlerMap = new HashMap<Method, MethodInvocationHandler>();

    public ProblemInvocationHandler(Class<T> cl, ProblemEventHandler eh) {
        this.m_problemEventHandler = eh;
        for (Method method : cl.getDeclaredMethods()) {
            MethodInvocationHandler mih = new MethodInvocationHandler(method);
            this.m_methodInvocationHandlerMap.put(method, mih);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ((args == null || args.length == 0) && method.getName().equals("toString")) {
            return this.toString();
        }
        MethodInvocationHandler mih = this.m_methodInvocationHandlerMap.get(method);
        return mih.invoke(args);
    }

    private String getMethodName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    class MethodInvocationHandler {
        private Method m_method;
        private ProblemMethod m_problemMethod;
        private String m_messageKey;
        private int m_locationParameterIndex = -1;

        public MethodInvocationHandler(Method method) {
            this.m_method = method;
            this.m_problemMethod = method.getAnnotation(ProblemMethod.class);
            if (this.m_problemMethod == null) {
                throw new IllegalArgumentException(ProblemInvocationHandler.this.getMethodName(method) + " is missing the " + ProblemMethod.class.getSimpleName() + " annotation");
            }
            this.check();
        }

        private void check() {
            int i;
            Class<?>[] paramTypes = this.m_method.getParameterTypes();
            Annotation[][] paramAnnotations = this.m_method.getParameterAnnotations();
            for (i = 0; i < paramAnnotations.length; ++i) {
                ProblemProperty ep = this.getErrorParameter(paramAnnotations[i]);
                if (ep == null) continue;
                Class<?> paramType = paramTypes[i];
                String propertyName = ep.value();
                Method m = MethodUtils.getAccessibleMethod(paramType, (String)("getOne" + TextUtil.ucFirst(propertyName)), (Class[])null);
                if (m == null) {
                    m = MethodUtils.getAccessibleMethod(paramType, (String)("is" + TextUtil.ucFirst(propertyName)), (Class[])null);
                }
                if (m == null) {
                    m = MethodUtils.getAccessibleMethod(paramType, (String)propertyName, (Class[])null);
                }
                if (m != null) continue;
                throw new IllegalArgumentException(ProblemInvocationHandler.this.getMethodName(this.m_method) + ": parameter class does not have a property " + propertyName);
            }
            for (i = 0; i < paramTypes.length; ++i) {
                Class<?> c = paramTypes[i];
                if (!Location.class.equals(c) || this.m_locationParameterIndex >= 0) continue;
                this.m_locationParameterIndex = i;
            }
        }

        public Object invoke(Object[] args) {
            try {
                args = this.processParameters(args);
                Location location = null;
                if (this.m_locationParameterIndex >= 0) {
                    location = this.getLocation(args);
                    args = this.removeLocation(args);
                }
                ProblemEvent ev = new ProblemEvent(location, this.m_problemMethod.severity(), this.m_messageKey, this.m_problemMethod.message(), args);
                ProblemInvocationHandler.this.m_problemEventHandler.handle(ev);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        private Location getLocation(Object[] args) {
            if (this.m_locationParameterIndex >= 0) {
                return (Location)args[this.m_locationParameterIndex];
            }
            return null;
        }

        private Object[] removeLocation(Object[] args) {
            Object[] result = args;
            if (this.m_locationParameterIndex >= 0) {
                int i;
                result = new Object[args.length - 1];
                for (i = 0; i < this.m_locationParameterIndex; ++i) {
                    result[i] = args[i];
                }
                for (i = this.m_locationParameterIndex + 1; i < args.length; ++i) {
                    result[i - 1] = args[i];
                }
            }
            return result;
        }

        private Object[] processParameters(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Annotation[][] paramAnnotations = this.m_method.getParameterAnnotations();
            for (int i = 0; i < paramAnnotations.length; ++i) {
                ProblemProperty ep = this.getErrorParameter(paramAnnotations[i]);
                if (ep == null) continue;
                Object arg = args[i];
                String propertyName = ep.value();
                Method m = MethodUtils.getAccessibleMethod(arg.getClass(), (String)propertyName, (Class[])null);
                args[i] = m != null ? m.invoke(arg, new Object[0]) : BeanUtils.getProperty((Object)arg, (String)propertyName);
            }
            return args;
        }

        private ProblemProperty getErrorParameter(Annotation[] paramAnnotations) {
            for (Annotation annotation : paramAnnotations) {
                if (!(annotation instanceof ProblemProperty)) continue;
                return (ProblemProperty)annotation;
            }
            return null;
        }
    }
}

