/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveSubmittedMessageExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveSubmittedMessageExample.class);

    public static void main(String[] args) {
        try {
            RandomMessageIDGenerator messageIdGenerator = new RandomMessageIDGenerator();
            ServerMessageReceiverListener messageReceiverListener = new ServerMessageReceiverListener((MessageIDGenerator)messageIdGenerator){
                final /* synthetic */ MessageIDGenerator val$messageIdGenerator;
                {
                    this.val$messageIdGenerator = messageIDGenerator;
                }

                public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
                    LOGGER.info("Receiving message : {}", (Object)new String(submitSm.getShortMessage()));
                    return this.val$messageIdGenerator.newMessageId();
                }

                public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }

                public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }

                public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                    return null;
                }

                public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
                }

                public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
                }
            };
            LOGGER.info("Listening ...");
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(8056);
            sessionListener.setMessageReceiverListener(messageReceiverListener);
            SMPPServerSession session = sessionListener.accept();
            LOGGER.info("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                LOGGER.info("Receive bind request for system id {} and password {}", (Object)request.getSystemId(), (Object)request.getPassword());
                if ("test".equals(request.getSystemId()) && "test".equals(request.getPassword())) {
                    LOGGER.info("Accepting bind request");
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    LOGGER.info("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                LOGGER.error("No binding request made after 5000 millisecond", (Throwable)e);
            }
            LOGGER.info("Closing session");
            session.unbindAndClose();
            LOGGER.info("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            LOGGER.error("PDUString exception", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("I/O exception", (Throwable)e);
        }
    }
}

