/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitLongMessageExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmitLongMessageExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        SMPPSession session = new SMPPSession();
        try {
            session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            Random random = new Random();
            int totalSegments = 3;
            OptionalParameter.Short sarMsgRefNum = OptionalParameters.newSarMsgRefNum((short)((short)random.nextInt()));
            OptionalParameter.Byte sarTotalSegments = OptionalParameters.newSarTotalSegments((int)3);
            for (int i = 0; i < 3; ++i) {
                int seqNum = i + 1;
                String message = "Message part " + seqNum + " of " + 3 + " ";
                OptionalParameter.Byte sarSegmentSeqnum = OptionalParameters.newSarSegmentSeqnum((int)seqNum);
                String messageId = SubmitLongMessageExample.submitMessage(session, message, (OptionalParameter)sarMsgRefNum, (OptionalParameter)sarSegmentSeqnum, (OptionalParameter)sarTotalSegments);
                LOGGER.info("Message submitted, message_id is {}", (Object)messageId);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
    }

    public static String submitMessage(SMPPSession session, String message, OptionalParameter sarMsgRefNum, OptionalParameter sarSegmentSeqnum, OptionalParameter sarTotalSegments) {
        String messageId = null;
        try {
            messageId = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, DataCodings.ZERO, (byte)0, message.getBytes(), new OptionalParameter[]{sarMsgRefNum, sarSegmentSeqnum, sarTotalSegments});
        }
        catch (PDUException e) {
            LOGGER.error("Invalid PDU parameter", (Throwable)e);
        }
        catch (ResponseTimeoutException e) {
            LOGGER.error("Response timeout", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            LOGGER.error("Receive invalid response", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            LOGGER.error("Receive negative response", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("I/O error occurred", (Throwable)e);
        }
        return messageId;
    }
}

