/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.examples.MessageReceiverListenerImpl;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitMultiExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmitMultiExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        SMPPSession session = new SMPPSession();
        try {
            session.setMessageReceiverListener((MessageReceiverListener)new MessageReceiverListenerImpl());
            String systemId = session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TRX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            LOGGER.info("Connected with SMSC with system id {}", (Object)systemId);
            try {
                Address address1 = new Address(TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657");
                Address address2 = new Address(TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504658");
                Address[] addresses = new Address[]{address1, address2};
                SubmitMultiResult result = session.submitMultiple("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", addresses, new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.FAILURE), ReplaceIfPresentFlag.REPLACE, (DataCoding)new GeneralDataCoding(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1, false), (byte)0, "jSMPP simplifies SMPP on Java platform".getBytes(), new OptionalParameter[0]);
                LOGGER.info("{} messages submitted, result message id {}", (Object)addresses.length, (Object)result.getMessageId());
                for (UnsuccessDelivery unsuccessDelivery : result.getUnsuccessDeliveries()) {
                    LOGGER.info("Unsuccessful delivery to {}: {}", (Object)unsuccessDelivery.getDestinationAddress(), (Object)unsuccessDelivery.getErrorStatusCode());
                }
                Thread.sleep(2000L);
            }
            catch (PDUException e) {
                LOGGER.error("Invalid PDU parameter", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                LOGGER.error("Response timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                LOGGER.error("Receive invalid response", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                LOGGER.error("Receive negative response", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("I/O error occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread interrupted", (Throwable)e);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
    }
}

